package com.yeejoin.amos.boot.module.tdc.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author DELL
 */
@Data
@Accessors(chain = true)
@TableName("tdc_report")
@ApiModel(value="CheckReport对象", description="校验报告表")
public class CheckReport {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @ApiModelProperty(value = "报告名称")
    private String name;

    @ApiModelProperty(value = "机构code")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构名称")
    private String amosOrgName;

    @ApiModelProperty(value = "报告地址")
    private String reportUrl;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "校验人名称")
    private String checkPeopleName;
}
