package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.yeejoin.amos.boot.module.tdc.api.entity.ModelItem;
import com.yeejoin.amos.boot.module.tdc.api.entity.SubmitRecord;
import com.yeejoin.amos.boot.module.tdc.api.service.SyncMethodService;
import com.yeejoin.amos.boot.module.tdc.biz.action.model.IdxProjectModel;
import com.yeejoin.amos.component.rule.RuleTrigger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Service
@Async("swjyAsyncExecutor")
@Slf4j
public class SyncMethodServiceImpl implements SyncMethodService {

    @Autowired
    RuleTrigger ruleTrigger;

    @Override
    public void checkItem(Map<String, List<ModelItem>> itemValue, SubmitRecord record) {
        try {
            itemValue.forEach((key, value) -> {
                IdxProjectModel idxProjectModel = new IdxProjectModel();
                idxProjectModel.setItemName(key);
                Map<String, Object> mapValue = value.stream().collect(Collectors.toMap(ModelItem::getCheckItemLabel, ModelItem::getCheckItemValue));
                mapValue.put("submitRecordId", record.getSequenceNbr());
                mapValue.put("batch_no", record.getBatchNo());
                mapValue.put("org_code", record.getAmosOrgCode());
                idxProjectModel.setPropertyValues(mapValue);

                // 调用规则校验模型
                try {
                    // 没有配决策流，processIds传null即可
                    Thread.sleep(1000);
                    String packageId = "数据填报/" + key;
                    ruleTrigger.publish(idxProjectModel, packageId, null);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            log.error("调用规则校验失败：");
        }
    }
}
