package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 接警记录导出
 */
@Data
@ApiModel(value="AlertCalledRecordDto", description="接警记录导出Dto类")
public class AlertCalledRecordDto {

   @ExcelIgnore
   private static final long serialVersionUID = 1L;

   @ExcelProperty(value = "接警时间", index = 0)
   @ApiModelProperty(value = "接警时间")
   private Date callTime;

   @ExcelProperty(value = "报警类型", index = 1)
   @ApiModelProperty(value = "报警类型")
   private String type;

   @ExcelProperty(value = "警情来源", index = 2)
   @ApiModelProperty(value = "警情来源")
   private String alertSource;

   @ExcelProperty(value = "警情类型", index = 3)
   @ApiModelProperty(value = "警情类型")
   private String alarmType;

   @ExcelProperty(value = "警情地址", index = 4)
   @ApiModelProperty(value = "警情地址")
   private String address;

   @ExcelIgnore
   @ApiModelProperty(value = "接警开始时间")
   private Date callTimeStart;

   @ExcelIgnore
   @ApiModelProperty(value = "接警结束时间")
   private Date callTimeEnd;

}
