package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentInformDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.EquipmentInform;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.EquipmentInformServiceImpl;
import feign.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 设备告知单
 *
 * @author system_generator
 * @date 2021-12-10
 */
@RestController
@Api(tags = "设备告知单Api")
@RequestMapping(value = "/equipment-inform")
public class EquipmentInformController extends BaseController {

    @Autowired
    EquipmentInformServiceImpl equipmentInformServiceImpl;

	@Autowired
	WorkflowFeignService workflowFeignService;

	/**
	 * 根据regionCode 获取设备告知单单号
	 * @param regionCode
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getInformCode/{regionCode}")
	@ApiOperation(httpMethod = "GET",value = "根据regionCode 获取设备告知单单号",  notes = "根据regionCode 获取设备告知单单号")
	public ResponseModel<String> getInformCode(@PathVariable String regionCode) {
		// 行政编码 + 年月 + 顺序号
		String code = regionCode +DateUtils.getDateNowShortNumber();
		int number = equipmentInformServiceImpl.count(new LambdaQueryWrapper<EquipmentInform>().like(EquipmentInform::getProductCode,regionCode));
		String numberStr = String.format("%04d", number);
		code += numberStr;
		return ResponseHelper.buildResponse(code);
	}

	/**
	 * 暂存新增设备告知单 有id 为更新无id 为新增
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "暂存新增设备告知单 有id 为更新无id 为新增", notes = "暂存新增设备告知单 有id 为更新无id 为新增")
	public ResponseModel<EquipmentInformDto> save(@RequestBody EquipmentInformDto model) {
		model = equipmentInformServiceImpl.createEquipmentInform(model,getSelectedOrgInfo());
		return ResponseHelper.buildResponse(model);
	}


	/**
	 * 提交设备告知单
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/submit")
	@ApiOperation(httpMethod = "POST", value = "提交设备告知单", notes = "提交设备告知单")
	public ResponseModel submit(@RequestBody EquipmentInformDto model) {
		if (ValidationUtil.isEmpty(model.getSequenceNbr())) {
			throw new BadRequest("参数校验失败.");
		}
		try {
			return CommonResponseUtil.success(equipmentInformServiceImpl.updateEquipmentInform(model,getSelectedOrgInfo()));
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
	}


    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个设备告知单",  notes = "根据sequenceNbr查询单个设备告知单")
	public ResponseModel<EquipmentInformDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(equipmentInformServiceImpl.queryDtoBySeq(sequenceNbr));
	}


	/**
	 * 列表分页查询
	 *
	 * @param pageNum  当前页
	 * @param pageSize 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/list")
	@ApiOperation(httpMethod = "GET", value = "告知书列表查询", notes = "告知书列表查询")
	public ResponseModel<Page<EquipmentInformDto>> queryForPage(@RequestParam(value = "pageNum") int pageNum, @RequestParam(value = "pageSize") int pageSize, String sort , EquipmentInformDto equipmentInformDto) {
		Page<EquipmentInformDto> page = new Page<EquipmentInformDto>();
		page.setCurrent(pageNum);
		page.setSize(pageSize);
		String sortParam = "";
		String sortRule = "";
		if(sort!=null) {  // 排序失效
			String[] date=  sort.split(",");
			if(date[1].equals("ascend")) {
				sortParam = RedisKey.humpToLine(date[0]);
				sortRule = "asc";
			}else {
				sortParam =RedisKey.humpToLine(date[0]);
				sortRule = "desc";
			}
		}else {
			sortParam = "rec_date";
			sortRule = "desc";
		}
		Page<EquipmentInformDto> pageBean = equipmentInformServiceImpl.queryDtoList(page,equipmentInformDto,sortParam,sortRule);
		Page<EquipmentInformDto> result = new Page<EquipmentInformDto>(pageNum,pageSize);
		long totle = pageBean.getTotal();
		result.setRecords(pageBean.getRecords());
		result.setTotal(totle);
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/delete_batch")
	@ApiOperation(httpMethod = "DELETE", value = "批量删除告知书信息", notes = "批量删除告知书信息")
	public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList){
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.batchDelete(sequenceNbrList));
	}

	/**
	 * 企业通过流程
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/finishWorkflow/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "通过流程", notes = "测试通过流程")
	public ResponseModel<Boolean> finishWorkflow(@PathVariable Long sequenceNbr) throws  Exception{
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.acceptInform(sequenceNbr,getSelectedOrgInfo()));
	}


	/**
	 * 接收方驳回告知书
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/dismissInform/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "接收方驳回告知书", notes = "接收方驳回告知书")
	public ResponseModel<Boolean> dismissInform(@PathVariable Long sequenceNbr) throws  Exception{
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.dismissInform(sequenceNbr,getSelectedOrgInfo()));
	}


	/**
	 * 企业撤回告知书
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/withdrawInform/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "企业撤回告知书", notes = "企业撤回告知书")
	public ResponseModel<Boolean> withdrawInform(@PathVariable Long sequenceNbr) throws  Exception{
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.withdrawInform(sequenceNbr,getSelectedOrgInfo()));
	}

	/**
	 * 接收方移交告知书
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/transferInform/{sequenceNbr}/{transferUnitId}")
	@ApiOperation(httpMethod = "GET", value = "接收方移交告知书", notes = "接收方移交告知书")
	public ResponseModel<Boolean> transferInform(@PathVariable Long sequenceNbr, @PathVariable Long transferUnitId) throws  Exception{
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.transferInform(sequenceNbr,getSelectedOrgInfo(),transferUnitId));
	}

	/**
	 * 企业废弃告知书
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/cancelInform/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "企业废弃告知书", notes = "企业废弃告知书")
	public ResponseModel<Boolean> cancelInform(@PathVariable Long sequenceNbr) throws  Exception{
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.cancelInform(sequenceNbr,getSelectedOrgInfo()));
	}


	/**
	 * 监管端撤回已经通过的申请
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/callbackInform/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "监管端撤回已经通过的申请", notes = "监管端撤回已经通过的申请")
	public ResponseModel<Boolean> callbackInform(@PathVariable Long sequenceNbr) throws  Exception{
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.callbackInform(sequenceNbr));
	}


	/**
	 * 列表分页查询
	 *
	 * @param pageNum  当前页
	 * @param pageSize 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/subList")
	@ApiOperation(httpMethod = "GET", value = "告知书列表查询-接收单位", notes = "告知书列表查询-接收单位")
	public ResponseModel<Page<EquipmentInformDto>> subList(@RequestParam(value = "pageNum") int pageNum, @RequestParam(value = "pageSize") int pageSize, String sort , EquipmentInformDto equipmentInformDto) {
		Page<EquipmentInformDto> page = new Page<EquipmentInformDto>();
		page.setCurrent(pageNum);
		page.setSize(pageSize);
		String sortParam = "";
		String sortRule = "";
		if(sort!=null) {  // 排序失效
			String[] date=  sort.split(",");
			if(date[1].equals("ascend")) {
				sortParam = RedisKey.humpToLine(date[0]);
				sortRule = "asc";
			}else {
				sortParam =RedisKey.humpToLine(date[0]);
				sortRule = "desc";
			}
		}else {
			sortParam = "rec_date";
			sortRule = "desc";
		}
		Page<EquipmentInformDto> pageBean = equipmentInformServiceImpl.queryDtoListSub(page,equipmentInformDto,sortParam,sortRule);
		Page<EquipmentInformDto> result = new Page<EquipmentInformDto>(pageNum,pageSize);
		long totle = pageBean.getTotal();
		result.setRecords(pageBean.getRecords());
		result.setTotal(totle);
		return ResponseHelper.buildResponse(result);
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/downloadFile/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "流程图高亮图片", notes = "流程图高亮图片")
	public ResponseEntity<String> downloadFile(@PathVariable Long sequenceNbr, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String processId = equipmentInformServiceImpl.queryBySeq(sequenceNbr).getProcessId();
		if(StringUtils.isBlank(processId)) {
			throw new BadRequest("未找到流程图信息");
		}
		Response feignResponse = workflowFeignService.thighLineImg(processId);
		try {
			Response.Body body = feignResponse.body();
//            response.setContentType("application/octet-stream");//
//            response.setHeader("content-type", "application/octet-stream");
//            response.setContentType("text/xml");//
//            response.setHeader("content-type", "text/xml");
//            response.setCharacterEncoding("utf-8");
//            response.setHeader("Content-Disposition", "attachment;fileName=workflow.svg");
//            response.reset();
//            byte[] b = new byte[1024];
//            int len;
//            while ((len = body.asInputStream().read(b, 0, 1024)) != -1) {
//                out.write(b, 0, len);
//            }
//            out.flush();
			return new ResponseEntity<String>(IOUtils.toString(body.asInputStream()),  HttpStatus.OK);
			//.toByteArray(body.asInputStream()), responseHeaders, HttpStatus.OK);
		} catch (Exception e) {
			throw new BaseException("Error exporting diagram", "500", processId);
		}

	}

}
