package com.yeejoin.amos.jpush.service.business.controller;

import cn.jpush.api.push.model.PushPayload;
import com.yeejoin.amos.jpush.common.entity.CommonResponse;
import com.yeejoin.amos.jpush.common.entity.CommonResponseUtil;
import com.yeejoin.amos.jpush.service.business.param.PushMsgParam;
import com.yeejoin.amos.jpush.service.jpush.AppMessagePushService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 获取用户信息
 *
 * @author gaodongdong
 */
@RestController
@RequestMapping(value = "/api/user")
@Api(tags = "用户信息api")
public class UserController  {

    private final Logger logger = LoggerFactory.getLogger(UserController.class);

   
    @Autowired
    private AppMessagePushService appMessagePushService;
    
  
    
    //极光推送
    
    @ApiOperation(value = "发送消息", notes = "发送消息")
    @RequestMapping(value = "/sendMessage", method = RequestMethod.POST)
    public CommonResponse sendMessage(@RequestBody List<PushMsgParam> responses) {
        try {
        	 appMessagePushService.sendMessage( responses);
            
            return CommonResponseUtil.success("发送成功");
        } catch (Exception e) {
            
            return CommonResponseUtil.failure("发送失败");
        }
    }
    
    @ApiOperation(value = "发送消息", notes = "发送消息")
    @RequestMapping(value = "/sendMessageone", method = RequestMethod.POST)
    public CommonResponse sendMessageone(@RequestBody PushMsgParam responses) {
        try {
        	 appMessagePushService.sendMessage( responses);
            
            return CommonResponseUtil.success("发送成功");
        } catch (Exception e) {
            
            return CommonResponseUtil.failure("发送失败");
        }
    }
    @ApiOperation(value = "发送消息", notes = "发送消息")
    @RequestMapping(value = "/pushNoticeMany", method = RequestMethod.POST)
    public CommonResponse pushNoticeMany(@RequestBody PushMsgParam responses) {
        try {
        	 appMessagePushService.pushNoticeMany( responses);
            
            return CommonResponseUtil.success("发送成功");
        } catch (Exception e) {
            
            return CommonResponseUtil.failure("发送失败");
        }
    }
    @ApiOperation(value = "发送消息", notes = "发送消息")
    @RequestMapping(value = "/buildPushPayload", method = RequestMethod.POST)
    public CommonResponse buildPushPayload(@RequestBody PushMsgParam responses) {
        try {
        	PushPayload  pushPayload =appMessagePushService.buildPushPayload( responses);
            
            return CommonResponseUtil.success(pushPayload);
        } catch (Exception e) {
            
            return CommonResponseUtil.failure("发送失败");
        }
    }
    
    @ApiOperation(value = "删除别名关联设备", notes = "删除别名关联设备")
    @RequestMapping(value = "/pushDevice", method = RequestMethod.GET)
    public CommonResponse pushDevice(@RequestParam("alias") String alias) {
        try {
        	boolean  falg =appMessagePushService.PushDevice( alias);
            if(falg){
            	return CommonResponseUtil.failure();
            }else{
            	return CommonResponseUtil.success();
            }
         } catch (Exception e) {
            
            return CommonResponseUtil.failure();
        }
    }
    @ApiOperation(value = "别名关联设备", notes = "别名关联设备")
    @RequestMapping(value = "/PushDeviceRegistration", method = RequestMethod.GET)
    public CommonResponse PushDeviceRegistration(@RequestParam("registrationId") String registrationId,@RequestParam("alias") String alias) {
        try {
        	boolean  falg =appMessagePushService.PushDeviceRegistration( registrationId,alias);
            if(falg){
            	return CommonResponseUtil.success();
            }else{
            	return CommonResponseUtil.failure();
            }
         } catch (Exception e) {
            
            return CommonResponseUtil.failure();
        }
    }
    
    
    
    
    
    
}