package com.yeejoin.amos.supervision.common.remote;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.supervision.business.feign.FeignConfiguration;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "${Security.fegin.name}", configuration = FeignConfiguration.class)
public interface IAMOSSecurityServer {

    @GetMapping(value = "/v1/company/tree")
    CommonResponse listCompanyTree();

    @GetMapping(value = "/v1/user/list")
    CommonResponse listUserByMenuCode(@RequestParam("permissionType") String permissionType,
                                      @RequestParam("path") String path);

    @GetMapping(value = "/v1/department/{departmentId}")
    CommonResponse getDepartmentByDeptId(@PathVariable("departmentId") String departmentId);

    @GetMapping(value = "/v1/department/list/{departmentIds}")
    CommonResponse listDepartmentByDeptIds(@PathVariable("departmentIds") String departmentIds);

    /**
     * 根据公司编号查询部门集合（数组）
     */
    @GetMapping(value = "/v1/department/tree/{companyId}")
    CommonResponse listDepartmentsByCompanyId(@PathVariable("companyId") String companyId);

    /**
     * 根据公司编号查询用户集合
     */
    @GetMapping(value = "/v1/department/tree/{companyId}")
    CommonResponse listUserByCompanyId(@PathVariable("companyId") String companyId);

    @GetMapping(value = "/v1/user/list/role/{roleIds}")
    CommonResponse listUserByRoleIds(@PathVariable("roleIds") String roleIds);

    @GetMapping(value = "/v1/user/list/batch/{userIds}")
    CommonResponse listUserByUserIds(@PathVariable("userIds") String userIds,    @RequestParam(value="needDetail",required = false) Boolean  needDetail);

    @GetMapping(value = "/v1/user/{userId}")
    CommonResponse getUserById(@PathVariable("userId") String userId);

    @GetMapping(value = "/v1/user/me")
    CommonResponse getUserByToken();

    /**
     * 根据公司组织机构代码查询用户集合
     */
    @GetMapping(value = "/v1/company")
    CommonResponse listUserByOrgCode(@RequestParam("orgCode") String orgCode);

    @GetMapping(value = "/v1/user/list/dept/{departmentId}")
    CommonResponse listUserByDepartmentId(@PathVariable("departmentId") String departmentId);

    @GetMapping(value = "/v1/company/subtree/{companyId}")
    CommonResponse getCompanyTreeByCompanyId(@PathVariable("companyId") String companyId);

    @GetMapping(value = "/v1/department/tree/{companyId}")
    CommonResponse getDepartmentTreeByCompanyId(@PathVariable("companyId") String companyId);

    @GetMapping(value = "/v1/permission/tree/curruser")
    CommonResponse listPermissionTree(@RequestParam("menuAgent") String menuAgent);

    @GetMapping(value = "/v1/{dictCode}/values")
    CommonResponse listDictionaryByDictCode(@RequestParam("dictCode") String dictCode);

    @PostMapping(value = "/v1/system/appLogin")
    CommonResponse loginFromApp(@RequestBody JSONObject appLoginParam);

    @DeleteMapping(value = "/v1/system/loginOut")
    CommonResponse loginOutFromApp();

    @GetMapping(value = "/v1/user/tree/{companyId}")
    CommonResponse listDepartmentUserTree(@PathVariable("companyId") String companyId);

    @PutMapping(value = "/v1/user/{userId}/password")
    CommonResponse editPassword(@PathVariable("userId") String userId,
                                @RequestBody JSONObject model);

    @GetMapping(value = "/v1/permission/list/{userId}/{permissionType}/path")
    CommonResponse getMenuPathByUserIdAndPermissionType(@PathVariable("userId") String userId,
                                                        @PathVariable("permissionType") String permissionType);

    @GetMapping(value = "/v1/role/list")
    CommonResponse listRoleByTypeAndPath(@RequestParam("permissionType") String permissionType,
                                      @RequestParam("path") String path);
}
