package com.yeejoin.amos.maintenance.common.remote;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.maintenance.business.util.Constants;
import com.yeejoin.amos.maintenance.business.util.StringUtil;
import com.yeejoin.amos.maintenance.core.common.response.WebStockResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service("remoteWebSocketServer")
public class RemoteWebSocketServer {
    private final RestTemplate restTemplate;
    
    @Value("${params.remoteWebsocketUrl}")
    private String remoteWebsocketUrl;

    @Value("${params.remoteWebSocketSendMsgUrl}")
    private String remoteWebSocketSendMsgUrl;
    
    private ObjectMapper objectMapper = new ObjectMapper();
    public RemoteWebSocketServer()
    {
        this.restTemplate = new RestTemplate();
    }
    
    
    public Object sendMessage(String message) throws Exception
    {
        Map<String, String> map = new HashMap<String, String>();
        map.put("filter", null);
        map.put("message", message);
        map.put("path", "spcMessage");
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<Map<String, String>>(map, headers);
        ResponseEntity responseEntity = restTemplate.exchange(remoteWebsocketUrl + "/generic/sendMessage",
                HttpMethod.POST, formEntity, String.class);

        responseEntity.getBody();
        if (StringUtil.isNotEmpty(responseEntity.getBody())) {
            Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(),Map.class);

            if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS) )
            {
                return commonResponse.get("dataList");
            }
        }
        return null;
    }

    public Object sendMessage(String message, String path) throws Exception
    {
        Map<String, String> map = new HashMap<String, String>();
        map.put("filter", null);
        map.put("message", message);
        map.put("path", path);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType
                .parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<Map<String, String>>(map, headers);
        ResponseEntity responseEntity = restTemplate.exchange(remoteWebSocketSendMsgUrl + "/generic/sendMessage",
                HttpMethod.POST, formEntity, String.class);

        responseEntity.getBody();
        if (StringUtil.isNotEmpty(responseEntity.getBody())) {
            Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(),Map.class);
            if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS) )
            {
                return commonResponse.get("dataList");
            }
        }
        return null;
    }
    
    @Async
    public void wsDataRefresh(String content){
    	WebStockResponse response = new WebStockResponse();
    	response.setType("dataRefresh");
    	response.setContent(content);
    	try {
			sendMessage(JSON.toJSONString(response).toString());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    
}
