package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 安全追溯-压力管道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "PipelineChangeItemDto")
public class PipelineChangeItemDto extends TechParamsPipelineChangeFieldDto {

    @FieldDisplayDefine(value = "设计单位名称")
    private String designUnitName;

    @FieldDisplayDefine(value = "检验检测流水id", isExist = false)
    private String jySeq;

    @FieldDisplayDefine(value = "安装信息流水", isExist = false)
    private String constructionInfoSeq;

    @FieldDisplayDefine(value = "安装单位名称")
    private String uscUnitName;

    @FieldDisplayDefine(value = "安装日期")
    private String uscDate;

    @FieldDisplayDefine(value ="检验类型", dictCode = "JYJC")
    private String inspectType;

    @FieldDisplayDefine(value ="检验机构统一信用代码")
    private String inspectOrgCode;

    @FieldDisplayDefine(value ="检验机构名称")
    private String inspectOrgName;

    @FieldDisplayDefine(value ="检验报告", type = JSON.class)
    private String inspectReport;

    @FieldDisplayDefine(value ="检验人员")
    private String inspectStaff;

    @FieldDisplayDefine(value ="检验日期")
    private Date inspectDate;

    @FieldDisplayDefine(value ="检验结论", dictCode = "JYJL")
    private String inspectConclusionCode;

    @FieldDisplayDefine(value ="检验结论名称", isExist = false)
    private String inspectConclusion;

    @FieldDisplayDefine(value = "下次检验日期")
    private Date nextInspectDate;

    @FieldDisplayDefine(value ="检验报告编号")
    private String inspectReportNo;

    @FieldDisplayDefine(value = "主键", isExist = false)
    private String projectContraptionId;

}
