package com.yeejoin.amos.boot.module.jg.biz.context;

import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
public class BizDataHandleStrategyContext {

    private final Map<String, IBizDataChangeHandleStrategy> strategyMap;


    public BizDataHandleStrategyContext(List<IBizDataChangeHandleStrategy> strategies) {
        this.strategyMap = strategies.stream()
                .collect(Collectors.toMap(
                        IBizDataChangeHandleStrategy::canHandleBizType,
                        Function.identity()
                ));
    }

    public IBizDataChangeHandleStrategy getStrategy(String bizType) {
        return Optional.ofNullable(strategyMap.get(bizType)).orElseThrow(() -> new RuntimeException(String.format("not found %s type strategy", bizType)));
    }

}
