package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintainNoticeDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintainNoticeServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 维修告知
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "维修告知工作流相关Api")
@RequestMapping(value = "/jg-maintain-workflow")
public class JgMaintainByWorkFlowController {

    @Autowired
    JgMaintainNoticeServiceImpl jgMaintainNoticeServiceImpl;

    private static final String TABLE_PAGE_ID = "maintainInfo";

    /**
     * 撤销
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancel")
    @ApiOperation(httpMethod = "POST", value = "维修告知撤销", notes = "维修告知撤销")
    public ResponseModel<JgMaintainNoticeDto> cancel(@RequestBody Map<String, Object> model) {
        JgMaintainNoticeDto maintainInfo = BeanUtil.mapToBean(((LinkedHashMap) model.get(TABLE_PAGE_ID)), JgMaintainNoticeDto.class, true);
        if (Objects.isNull(maintainInfo)) {
            throw new IllegalArgumentException("参数maintainInfo不能为空");
        }
        jgMaintainNoticeServiceImpl.cancel(maintainInfo);
        return ResponseHelper.buildResponse(maintainInfo);
    }

    /**
     * 受理
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/accept")
    @ApiOperation(httpMethod = "POST", value = "维修告知受理", notes = "维修告知受理")
    public ResponseModel<JgMaintainNoticeDto> accept(@RequestBody Map<String, Object> model, String op) {
        // TODO 受理维修告知流程
        LinkedHashMap model1 = (LinkedHashMap) model.get("model");
        LinkedHashMap maintainInfo = (LinkedHashMap) model1.get(TABLE_PAGE_ID);
        String opinion = model.get("opinion").toString();
        JgMaintainNoticeDto jgMaintainNoticeDto = JSON.parseObject(JSON.toJSONString(maintainInfo), JgMaintainNoticeDto.class);
        jgMaintainNoticeServiceImpl.accept(jgMaintainNoticeDto, op, opinion, jgMaintainNoticeDto);
        return ResponseHelper.buildResponse(null);
    }
}
