package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.enableDisable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Sets;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.biz.event.CommonPublisher;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEnableDisable;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 设备停用启用编辑处理器
 */
@Component
public class EnableDisableDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final EnableDisableEditUpdateService enableDisableEditUpdateService;

    protected EnableDisableDataChangeHandler(CommonPublisher routerEventPublisher, ApplicationContext applicationContext, EnableDisableEditUpdateService enableDisableEditUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.enableDisableEditUpdateService = enableDisableEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_EQUIPMENT_START_STOP.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Boolean.TRUE;
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        return enableDisableEditUpdateService.getEqsByApplyNo(applyNo);
    }

    /**
     * 管道专用-判断数据是实时落库，还是先存到json
     * @param applyNo 单据号
     * @return 是否需要临时存储
     */
    @Override
    public Boolean requiresTemporarySave(String applyNo) {
        return false;
    }

    @Override
    public Boolean bizIsFinished(String applyNo) {
        JgEnableDisable jgEnableDisable = enableDisableEditUpdateService.getEnableDisableService().getOne(new LambdaQueryWrapper<JgEnableDisable>().eq(JgEnableDisable::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgEnableDisable::getAuditStatus));
        return jgEnableDisable.getAuditStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName());
    }

    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        JgEnableDisable jgEnableDisable = enableDisableEditUpdateService.getEnableDisableService()
                .getOne(new LambdaQueryWrapper<JgEnableDisable>().eq(JgEnableDisable::getApplyNo, applyNo)
                        .select(BaseEntity::getSequenceNbr, JgEnableDisable::getProjectContraptionId));
        Set<String> pIds = Sets.newHashSet(jgEnableDisable.getProjectContraptionId());
        pIds.remove(null);
        pIds.remove("");
        return pIds;
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
