package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipmentCategoryEnum {

    /**
     * *行政区划分及对应初始监管码
     */

    XZQHDT("行政区划电梯", "XZQHDT", "行政区划电梯", null),
    XZQH("行政区划", "XZQH", "行政区划", null),
    BLW("补零位", "0", "补零位", null),
    JGM("监管码初始码", "0000001", "监管码初始码", null),
    XXCSM("西咸96333初始码", "85000", "31", "610100"),
    BJCSM("宝鸡96333初始码", "13000", "32", "610300"),
    XYCSM("咸阳96333初始码", "75000", "33", "610400"),
    TCCSM("铜川96333初始码", "05000", "34", "610200"),
    WNCSM("渭南96333初始码", "13000", "35", "610500"),
    YACSM("延安96333初始码", "11000", "36", "610600"),
    YUCSM("榆林96333初始码", "10000", "37", "610800"),
    HZCSM("汉中96333初始码", "09000", "38", "610700"),
    AKCSM("安康96333初始码", "11000", "39", "610900"),
    SLCSM("商洛96333初始码", "06000", "40", "611000"),
    YLCSM("杨陵96333初始码", "70000", "41", "610403"),
    HCCSM("韩城96333初始码", "08000", "42", "610581"),
    SMCSM("神木96333初始码", "06000", "43", "610881"),
    FGCSM("府谷96333初始码", "02000", "44", "610822"),
    YJL("已拒领", "6037", "已拒领", null),
    YRL("已认领", "6035", "已认领", null),
    DRL("待认领", "6036", "待认领", null),
    CSZT("初始状态", "0", "初始状态", null),
    YSY("已使用", "1", "已使用", null),
    WSY("未使用", "2", "未使用", null),
    BF("报废", "6", "报废", null);

    private String name;
    private String code;
    private String value;
    private String cityCode;
    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();
    public static Map<String, String> getValue = new HashMap<>();
    public static final Map<String, String> getCityCodeValue = new HashMap<>();
    private static final Map<String, String> valueToCodeMap = new HashMap<>();

    static {
        for (EquipmentCategoryEnum e : EquipmentCategoryEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.value, e.code);
            getValue.put(e.value, e.code);
            if (e.cityCode != null) {
                getCityCodeValue.put(e.cityCode, e.value);
            }
            valueToCodeMap.put("96333_" + e.value, e.getValue() + e.getCode());
        }
    }

    // 根据value获取对应的code
    public static String getCodeByValue(String value) {
        return valueToCodeMap.get(value);
    }
}
