package com.yeejoin.amos.api.openapi.face.dto;


import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 管道检验检测结果数据接收
 *
 * @author system_generator
 */
@Data
@ApiModel(value = "PipelineInspectionResultDto", description = "管道检验检测结果数据接收")
public class PipelineInspectionResultDto implements Serializable {

    @ApiModelProperty(value = "报检单号")
    private String applicationNo;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "核准证号/许可证号")
    private String licenseNumber;

    @ApiModelProperty(value = "检验报告编号")
    private String resultNo;

    @ApiModelProperty(value = "内部人员代码")
    private String innerPersonCode;

    @ApiModelProperty(value = "检验结论")
    private String inspectionConclusion;

    @ApiModelProperty(value = "检验日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date inspectionDate;

    @ApiModelProperty(value = "下次检验日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date nextInspectionDate;

    @ApiModelProperty(value = "检验开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date inspectionStartDate;

    @ApiModelProperty(value = "检验结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date inspectionEndDate;

    @ApiModelProperty(value = "检验结果汇总")
    private String inspectionResultSummary;

    @ApiModelProperty(value = "不符合项")
    private JSONArray nonConformance;

    @ApiModelProperty(value = "附件")
    private List<AttachmentData> attachments;

    /**
     * 校验检验系统唯一流水号,排查问题，跟踪问题使用
     */
    private String traceId;

    @ApiModelProperty(value = "报检的管道")
    private List<PipelineResultItemDto> inspectionEquips;
}
