package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 平台操作接口类型枚举
 *
 ***/
@Getter
@AllArgsConstructor
public enum PlatformOpMethodTypeEnum {

    CREATE("create", "创建"),
    INSERT("insert", "插入"),
    UPDATE("update", "更新"),
    DELETE("delete", "删除");

    private String code;
    private String name;

    public static PlatformOpMethodTypeEnum getEnumByCode(String code) {
        for (PlatformOpMethodTypeEnum status : PlatformOpMethodTypeEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }
}
