package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 户用光伏监盘逆变器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JpInverterDto", description="户用光伏监盘逆变器表")
public class JpInverterDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "sn编码")
    private String snCode;

    @ApiModelProperty(value = "状态")
    private String state;

    @ApiModelProperty(value = "额定功率")
    private Double ratedPower;

    @ApiModelProperty(value = "采集器id")
    private Long collectorId;

    @ApiModelProperty(value = "采集器sn编码")
    private String collectorSnCode;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "实时功率")
    private Double currentPower;

    @ApiModelProperty(value = "日发电量")
    private Double dayPowerGeneration;

    @ApiModelProperty(value = "月发电量")
    private Double monthPowerGeneration;

    @ApiModelProperty(value = "年发电量")
    private Double yearPowerGeneration;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "国标")
    private String nationalStandard;

    @ApiModelProperty(value = "版本号")
    private String version;

    @ApiModelProperty(value = "满发小时数")
    private String generationHours;

    @ApiModelProperty(value = "质保期")
    private String warrantyPeriod;

    @ApiModelProperty(value = "IGBT温度")
    private String igbtTemperature;

    @ApiModelProperty(value = "AFCI方案")
    private String afciProgramme;

    @ApiModelProperty(value = "AFCI版本")
    private String afciVersion;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "第三方电站id")
    private String thirdStationId;

    @ApiModelProperty(value = "装机容量")
    private Integer capacity;

    @ApiModelProperty(value = "累计发电量")
    private Double totalPowerGeneration;

    @ApiModelProperty(value = "所属电站")
    private String stationName;

    private List<String> stationIds;
}
