package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpPersonStation;
import com.yeejoin.amos.boot.module.hygf.api.entity.PersonnelBusiness;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpCollectorMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpInverterMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpPersonStationMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpStationMapper;
import com.yeejoin.amos.boot.module.standard.api.entity.PublicAgencyUser;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.*;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpStationServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 第三方场站
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "第三方场站Api")
@RequestMapping(value = "/jp-station")
public class JpStationController extends BaseController {

    @Autowired
    JpStationServiceImpl jpStationServiceImpl;
    @Autowired
    JpPersonStationMapper pPersonStationMapper;
    @Autowired
    JpStationMapper jpStationMapper;
    @Autowired
    JpCollectorMapper jpCollectorMapper;
    @Autowired
    JpInverterMapper jpInverterMapper;

    /**
     * 新增第三方场站
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增第三方场站", notes = "新增第三方场站")
	public ResponseModel<JpStationDto> save(@RequestBody JpStationDto model) {
	    model = jpStationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新第三方场站", notes = "根据sequenceNbr更新第三方场站")
	public ResponseModel<JpStationDto> updateBySequenceNbrJpStation(@RequestBody JpStationDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jpStationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除第三方场站", notes = "根据sequenceNbr删除第三方场站")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jpStationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getBysequenceNbr")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个第三方场站",  notes = "根据sequenceNbr查询单个第三方场站")
	public ResponseModel<JpStationDto> selectOne( String id) {
	    Long sequenceNbr=Long.valueOf(id);
        JpStationDto jpStationDto=  jpStationServiceImpl.queryBySeq(sequenceNbr);
        LambdaQueryWrapper<JpInverter> qug=new LambdaQueryWrapper<>();
        qug.eq(JpInverter::getThirdStationId,jpStationDto.getThirdStationId());
        List<JpInverter> jpInverter=jpInverterMapper.selectList(qug);
        LambdaQueryWrapper<JpCollector> qug1=new LambdaQueryWrapper<>();
        qug1.eq(JpCollector::getThirdStationId,jpStationDto.getThirdStationId());
        List<JpCollector> JpCollector=jpCollectorMapper.selectList(qug1);
        jpStationDto.setJpCollector(JpCollector);
        jpStationDto.setJpInverter(jpInverter);
	    return ResponseHelper.buildResponse(jpStationDto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryPage")
    @ApiOperation(httpMethod = "GET",value = "场站列表",  notes = "场站列表")
    public ResponseModel<Page<JpStationDto>> queryForDealerReviewPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, JpStationDto reviewDto) {

//        if(reviewDto.getThirdStationId()==null){
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
            if(pPersonStation!=null&&!pPersonStation.isEmpty()){
                reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
            }else{
                return ResponseHelper.buildResponse(null);
            }
//        }
        Page<JpStationDto> page=jpStationServiceImpl.queryForJpStationPage(current,size,reviewDto);
        return ResponseHelper.buildResponse(page);
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/countState")
    @ApiOperation(httpMethod = "GET",value = "场站列表",  notes = "场站列表")
    public ResponseModel< Map<String,Object> > countState(JpStationDto reviewDto) {

            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
            reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
        List<Map<String,Object>> list= jpStationMapper.countState(reviewDto);
        Map<String,Object>  collector =new HashMap<>();
        collector.put("zx",0);
        collector.put("bj",0);
        collector.put("lx",0);
            if(list!=null&&!list.isEmpty()){
                for (Map<String, Object> map : list) {
                    if("在线".equals(map.get("state").toString())){
                        collector.put("zx",Integer.valueOf(map.get("num").toString()));
                    }else if("离线".equals(map.get("state").toString())){
                        collector.put("lx",Integer.valueOf(map.get("num").toString()));
                    }else if("报警".equals(map.get("state").toString())){
                        collector.put("bj",Integer.valueOf(map.get("num").toString()));
                    }
                }
            }
        return ResponseHelper.buildResponse(collector);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getpStation")
    @ApiOperation(httpMethod = "GET",value = "设备监控",  notes = "设备监控")
    public ResponseModel<Map<String,Object>> getpStation(JpStationDto reviewDto) {

        //获取当前人管理场站
        LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
        qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
        List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);

        if(pPersonStation!=null&&!pPersonStation.isEmpty()){
            reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
        }else{
            return ResponseHelper.buildResponse(null);
        }
        List<Map<String,Object>>  listCollector=  jpCollectorMapper.queryCollectorCountStatus(reviewDto);
        List<Map<String,Object>>  listInverter=  jpInverterMapper.queryInverterCountStatus(reviewDto);
        Map<String,Object>  collector =new HashMap<>();
        collector.put("zx",0);
        collector.put("gj",0);
        collector.put("lx",0);
        Map<String,Object>  inverter =new HashMap<>();
        inverter.put("zx",0);
        inverter.put("gj",0);
        inverter.put("lx",0);
        if(!listCollector.isEmpty()){
            for (Map<String, Object> map : listCollector) {
                if("在线".equals(map.get("state").toString())){
                    collector.put("zx",Integer.valueOf(map.get("num").toString()));
                }else if("离线".equals(map.get("state").toString())){
                    collector.put("lx",Integer.valueOf(map.get("num").toString()));
                }else if("报警".equals(map.get("state").toString())){
                    collector.put("gj",Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        if(!listInverter.isEmpty()){
            for (Map<String, Object> map : listInverter) {
                if("在线".equals(map.get("state").toString())){
                    inverter.put("zx",Integer.valueOf(map.get("num").toString()));
                }else if("离线".equals(map.get("state").toString())){
                    inverter.put("lx",Integer.valueOf(map.get("num").toString()));
                }else if("报警".equals(map.get("state").toString())){
                    inverter.put("gj",Integer.valueOf(map.get("num").toString()));
                }
            }
        }
        Map<String,Object> map=new HashMap<>();
        map.put("collector",collector);
        map.put("inverter",inverter);
        return ResponseHelper.buildResponse(map);

    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryListcz")
    @ApiOperation(httpMethod = "GET",value = "登陆人管理场站列表",  notes = "登陆人管理场站列表")
    public ResponseModel<List<JpPersonStation>> queryList( ) {
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
        return ResponseHelper.buildResponse(pPersonStation);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryUserListyz")
    @ApiOperation(httpMethod = "GET",value = "登陆人管理场站业主列表",  notes = "登陆人管理场站业主列表")
    public ResponseModel<List<String>> queryUserList( ) {
        //获取当前人管理场站
        LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
        qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
        List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
        List data=new ArrayList();
       if(pPersonStation!=null&& !pPersonStation.isEmpty()){
           for (JpPersonStation jpPersonStation : pPersonStation) {
               data.add(jpPersonStation.getOwner());
           }
       }
        return ResponseHelper.buildResponse(data);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "电站监控电量收益",   notes = "电站监控电量收益")
    @GetMapping(value = "/getIncomePower")
    public ResponseModel<JpStationDto> getIncomePower(JpStationDto reviewDto) {
        //获取当前人管理场站
        if(reviewDto.getThirdStationId()==null){
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
            if(pPersonStation!=null&&!pPersonStation.isEmpty()){
                reviewDto.setStatioId(pPersonStation.isEmpty()?null:pPersonStation);
            }else{
                return  ResponseHelper.buildResponse(null);
            }
      }
        return ResponseHelper.buildResponse(jpStationMapper.queryCount(reviewDto));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "工率曲线",   notes = "电站监控电量收益")
    @GetMapping(value = "/getPowerqx")
    public ResponseModel< Map<String, List<Object>>> getPowerqx(JpStationDto reviewDto,String date, String type) {
        //获取当前人管理场站
        List<Long> data=new ArrayList();
        if(reviewDto.getThirdStationId()==null){
            //获取当前人管理场站
            LambdaQueryWrapper<JpPersonStation> qug=new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId,getUserInfo().getUserId());
            List<JpPersonStation> pPersonStation=pPersonStationMapper.selectList(qug);
            if(pPersonStation!=null&&!pPersonStation.isEmpty()){

                for (JpPersonStation jpPersonStation : pPersonStation) {
                    data.add(Long.valueOf(jpPersonStation.getStationId()));
                }
            }else{
                return  ResponseHelper.buildResponse(null);
            }
        }else{
            data.add(Long.valueOf(reviewDto.getThirdStationId()));
        }
        return ResponseHelper.buildResponse(jpStationServiceImpl.getPowerqx( date,  type,data));
    }



}
