package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryAllDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryMonthDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryYearDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInvertorElecHistoryDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpInvertorElecHistory;
import com.yeejoin.amos.boot.module.hygf.api.service.ITdHygfJpInvertorElecHistoryService;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHygfJpInvertorElecHistoryMapper;
import com.yeejoin.amos.boot.module.hygf.api.util.TimeUtil;

/**
 * 户用光伏监盘逆变器电能历史表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class TdHygfJpInvertorElecHistoryServiceImpl extends
		BaseService<TdHygfJpInvertorElecHistoryDto, TdHygfJpInvertorElecHistory, TdHygfJpInvertorElecHistoryMapper>
		implements ITdHygfJpInvertorElecHistoryService {

	@Autowired
	private JpInverterServiceImpl jpInvertorServiceImpl;

	/**
	 * 分页查询
	 */
	public Page<TdHygfJpInvertorElecHistoryDto> queryForTdHygfJpInvertorElecHistoryPage(
			Page<TdHygfJpInvertorElecHistoryDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<TdHygfJpInvertorElecHistoryDto> dayList(long id, Date day) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);
		if (invertor != null) {
			List<TdHygfJpInvertorElecHistoryDto> list = this.baseMapper.dayList(invertor.getSnCode(),
					invertor.getThirdStationId(), TimeUtil.getStartTimeOfDay(day), TimeUtil.getEndTimeOfDay(day));
			if (!list.isEmpty()) {
				list.forEach(i -> {
					i.setTimeFormat(TimeUtil.minuteFormat(i.getTime()));
				});
			}
			return list;
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInvertorElecHistoryMonthDto> monthList(long id, Date month) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);
		Calendar cal = Calendar.getInstance();
		cal.setTime(month);
		String monthStr = String.valueOf(cal.get(Calendar.YEAR)) + "-" + String.valueOf(cal.get(Calendar.MONTH) + 1);
		if (invertor != null) {
			return this.baseMapper.monthList(invertor.getSnCode(), invertor.getThirdStationId(), monthStr);
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInvertorElecHistoryYearDto> yearList(long id, Date year) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);
		Calendar cal = Calendar.getInstance();
		cal.setTime(year);
		String yearStr = String.valueOf(cal.get(Calendar.YEAR));
		if (invertor != null) {
			return this.baseMapper.yearList(invertor.getSnCode(), invertor.getThirdStationId(), yearStr);
		}
		return new ArrayList<>();
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInvertorElecHistoryAllDto> allList(long id) {
		JpInverter invertor = jpInvertorServiceImpl.getById(id);

		if (invertor != null) {
			return this.baseMapper.allList(invertor.getSnCode(), invertor.getThirdStationId());
		}
		return new ArrayList<>();
	}

	@Async
	public Object syncData() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -1);
		Date dayTime = cal.getTime();
		int day = cal.get(Calendar.DATE);
		int month = cal.get(Calendar.MONTH) + 1;
		int year = cal.get(Calendar.YEAR);
		// 月表
		List<Map<String, Object>> monthList = this.baseMapper.dayToMonth(TimeUtil.getStartTimeOfDay(dayTime),
				TimeUtil.getEndTimeOfDay(dayTime));
		for (int i = 0; i < monthList.size(); i++) {
			monthList.get(i).put("created_time", dayTime.getTime() + i);
			monthList.get(i).put("day", day);
			monthList.get(i).put("year_month", year + "-" + month);
		}
		if (!monthList.isEmpty()) {
			this.baseMapper.updateMonth(monthList);
			// 年表
			List<Map<String, Object>> yearList = this.baseMapper.monthToYear(String.valueOf(year + "-" + month));
			List<JpInvertorElecHistoryYearDto> oldYearList = this.baseMapper.yearList(null, null, String.valueOf(year));
			for (int i = 0; i < yearList.size(); i++) {
				Map<String, Object> map = yearList.get(i);
				yearList.get(i).put("year", year);
				yearList.get(i).put("month", month);
				long time = dayTime.getTime() + i;
				for (JpInvertorElecHistoryYearDto dto : oldYearList) {
					if (dto.getThirdStationId() != null && dto.getSnCode() != null
							&& map.get("third_station_id") != null && map.get("sn_code") != null
							&& map.get("month") != null && map.get("year") != null
							&& dto.getThirdStationId().equals(map.get("third_station_id").toString())
							&& dto.getSnCode().equals(map.get("sn_code").toString())
							&& dto.getYear().equals(map.get("year").toString())
							&& dto.getMonth().equals(map.get("month").toString())) {
						time = dto.getCreatedTime();
						break;
					}
				}
				yearList.get(i).put("created_time", time);
			}
			if (!yearList.isEmpty()) {
				this.baseMapper.updateYear(yearList);
				// 总表
				List<Map<String, Object>> allList = this.baseMapper.yearToAll(String.valueOf(year));
				List<JpInvertorElecHistoryAllDto> oldAllList = this.baseMapper.allList(null, null);
				for (int i = 0; i < allList.size(); i++) {
					Map<String, Object> map = allList.get(i);
					allList.get(i).put("year", year);
					long time = dayTime.getTime() + i;
					for (JpInvertorElecHistoryAllDto dto : oldAllList) {
						if (dto.getThirdStationId() != null && dto.getSnCode() != null
								&& map.get("third_station_id") != null && map.get("sn_code") != null
								&& map.get("year") != null
								&& dto.getThirdStationId().equals(map.get("third_station_id").toString())
								&& dto.getSnCode().equals(map.get("sn_code").toString())
								&& dto.getYear().equals(map.get("year").toString())) {
							time = dto.getCreatedTime();
							break;
						}
					}
					allList.get(i).put("created_time", time);
				}
				if (!allList.isEmpty()) {
					this.baseMapper.updateAll(allList);
				}
			}
		}
		return null;
	}
}