package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationPlan;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationPlanMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESDailyPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESMoonPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SeriesData;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.DateUtil;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/10
 */
@Service
public class LargeScreenImpl {
    @Autowired
    CommonServiceImpl commonServiceImpl;
    @Autowired
    StationPlanMapper StationPlanMapper;
    @Autowired
    EmqKeeper emqKeeper;

    private final String SS = "瞬时风速";
    private final String ZFS = "WTX-801_25_WTX-801_总辐射";
    private final String ZFSLJ = "WTX-801_25_WTX-801_总辐射累计";
    private final String RSD = "日发电量";
    private final String YFD = "月发电量";
    private final String NFD = "年发电量";


    /**
     * 全国
     */
    @Scheduled(cron = "0/10 * * * * ?")
    public Map<String, Double> getqg() {
        Map<String, Double> mapdta = new HashMap<>();
        mapdta.put("SS", 0d);
        mapdta.put("ZFS", 0d);
        mapdta.put("ZFSLJ", 0d);
        mapdta.put("RSD", 0d);
        mapdta.put("YFD", 0d);
        mapdta.put("NFD", 0d);
        mapdta.put("YJHWC", 0d);
        mapdta.put("NJHWC", 0d);
        //平均数
        List<String> value = new ArrayList<>();
        value.add(SS);
        value.add(ZFS);
        value.add(ZFSLJ);
        Map<String, List<String>> map = new HashMap<>();
        map.put("equipmentIndexName.keyword", value);

        List<? extends Terms.Bucket> lidate = commonServiceImpl.getgroupavg(map, "valueF", "equipmentIndexName.keyword", ESEquipments.class);
        DecimalFormat format2 = new DecimalFormat("#.0000");
        for (Terms.Bucket bucket : lidate) {
            Aggregations aggregation = bucket.getAggregations();
            List<Aggregation> listdata = Objects.nonNull(aggregation) ? aggregation.asList() : null;
            for (Aggregation agg : listdata) {
                ParsedAvg parsedAvg = (ParsedAvg) agg;

                switch (bucket.getKeyAsString()) {
                    case SS:
                        mapdta.put("SS", Double.valueOf(format2.format(parsedAvg.getValue())));
                        break;
                    case ZFS:
                        mapdta.put("ZFS", Double.valueOf(format2.format(parsedAvg.getValue())));
                        break;
                    case ZFSLJ:
                        mapdta.put("ZFSLJ", Double.valueOf(format2.format(parsedAvg.getValue())));
                        break;
                    default:
                        break;
                }
            }
        }

        //总和
        value.clear();
        value.add(RSD);
        value.add(YFD);
        value.add(NFD);
        List<? extends Terms.Bucket> lidatesum = commonServiceImpl.getgroupsum(map, "valueF", "equipmentIndexName.keyword", ESEquipments.class);

        for (Terms.Bucket bucket : lidatesum) {
            Aggregations aggregation = bucket.getAggregations();
            List<Aggregation> listdata = Objects.nonNull(aggregation) ? aggregation.asList() : null;
            for (Aggregation agg : listdata) {
                ParsedSum parsedSum = (ParsedSum) agg;
                switch (bucket.getKeyAsString()) {
                    case RSD:
                        mapdta.put("RSD", Double.valueOf(format2.format(parsedSum.getValue()*CommonConstans.pvGenPoweActor* CommonConstans.pvGenPoweActorDay)));
                        break;
                    case YFD:
                        mapdta.put("YFD", Double.valueOf(format2.format(parsedSum.getValue()*CommonConstans.pvGenPoweActornew)));
                        break;
                    case NFD:
                        mapdta.put("NFD", Double.valueOf(format2.format(parsedSum.getValue()*CommonConstans.pvGenPoweActorYear)));
                        break;
                    default:
                        break;
                }
            }
        }
        //计算月完成百分比
        //当前月份 获取
        LocalDate currentDate = LocalDate.now();
        int month = currentDate.getMonthValue();

        QueryWrapper<StationPlan> wrapper = new QueryWrapper<>();
        wrapper.select("ifnull(sum(value), 0) as sum_value");
        wrapper.eq("monthly", month);
        List<Map<String, Object>> list = StationPlanMapper.selectMaps(wrapper);
        Double sumValue = list != null && !list.isEmpty() ? (Double) list.get(0).get("sum_value") : 0;
        //计算年完成百分比
        Double ybfb = sumValue > 0 ? mapdta.get("YFD") / sumValue * 100 : 0;
        ybfb = new BigDecimal(ybfb).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();

        mapdta.put("YJHWC", ybfb);
        QueryWrapper<StationPlan> wrapper1 = new QueryWrapper<>();
        wrapper1.select("ifnull(sum(value), 0) as sum_value");
        List<Map<String, Object>> list1 = StationPlanMapper.selectMaps(wrapper1);
        Double sumValuen = list1 != null && !list1.isEmpty() ? (Double) list1.get(0).get("sum_value") : 0;
        Double ybfbn = sumValuen > 0 ? mapdta.get("NFD") / sumValue * 100 : 0;
        ybfbn = new BigDecimal(ybfbn).setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
        mapdta.put("NJHWC", ybfbn);
        try {
            emqKeeper.getMqttClient().publish("qg/yxzb", JSON.toJSONString(mapdta).getBytes(),0,false);
        } catch (MqttException e) {
            e.printStackTrace();
        }
        return mapdta;

    }

    @Scheduled(cron = "0/10 * * * * ?")
    private void sendQYYXZBMqtt(){
        List<StationCacheInfoDto> listStationCacheInfoDto = commonServiceImpl.getListStationCacheInfoDto();
        Map<String, List<StationCacheInfoDto>> belongAreaList = listStationCacheInfoDto.stream().collect(Collectors.groupingBy(StationCacheInfoDto::getAreaCode));
        for (String s : belongAreaList.keySet()) {
            //List<String> ids = belongAreaList.get(s).stream().map(StationCacheInfoDto::getFanGatewayId).collect(Collectors.toList());
            getqy(belongAreaList.get(s),s);
        }
    }




    /**
     * 区域
     **/
    public Map<String, Double> getqy(List<StationCacheInfoDto> gatewayId,String s) {
        Map<String, Double> mapdta = new HashMap<>();
        mapdta.put("SS", 0d);
        mapdta.put("ZFS", 0d);
        mapdta.put("ZFSLJ", 0d);
        mapdta.put("RSD", 0d);
        mapdta.put("YFD", 0d);
        mapdta.put("NFD", 0d);
        mapdta.put("YJHWC", 0d);
        mapdta.put("NJHWC", 0d);
        //平均数
        List<String> value = new ArrayList<>();

        List<String> ids = gatewayId.stream().map(StationCacheInfoDto::getFanGatewayId).collect(Collectors.toList());
        value.add(SS);
        value.add(ZFS);
        value.add(ZFSLJ);
        Map<String, List<String>> map = new HashMap<>();
        map.put("equipmentIndexName.keyword", value);
        map.put("gatewayId.keyword", ids);

        List<? extends Terms.Bucket> lidate = commonServiceImpl.getgroupavg(map, "valueF", "equipmentIndexName.keyword", ESEquipments.class);
        DecimalFormat format2 = new DecimalFormat("#.0000");
        for (Terms.Bucket bucket : lidate) {
            Aggregations aggregation = bucket.getAggregations();
            List<Aggregation> listdata = Objects.nonNull(aggregation) ? aggregation.asList() : null;
            for (Aggregation agg : listdata) {
                ParsedAvg parsedAvg = (ParsedAvg) agg;

                switch (bucket.getKeyAsString()) {
                    case SS:
                        mapdta.put("SS", Double.valueOf(format2.format(parsedAvg.getValue())));
                        break;
                    case ZFS:
                        mapdta.put("ZFS", Double.valueOf(format2.format(parsedAvg.getValue())));
                        break;
                    case ZFSLJ:
                        mapdta.put("ZFSLJ", Double.valueOf(format2.format(parsedAvg.getValue())));
                        break;
                    default:
                        break;
                }
            }
        }


        //日发电量
        AtomicReference<Double> dailyPower = new AtomicReference<>(0.0);
        //月发电量
        AtomicReference<Double> monthlyPower = new AtomicReference<>(0.0);
        //年发电量
        AtomicReference<Double> annualPower = new AtomicReference<>(0.0);
        for (StationCacheInfoDto stationBasic : gatewayId) {

            if ("FDZ".equals(stationBasic.getStationType())) {
                Map<String, List<String>> queryCondtion = new HashMap<>();
                queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("日发电量", "月发电量", "年发电量"));
                queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
                List<ESEquipments> result = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
                dailyPower.updateAndGet(v -> v + keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "日发电量")));
                monthlyPower.updateAndGet(v -> v + keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "月发电量")));
                annualPower.updateAndGet(v -> v + keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "年发电量")));
            } else {
                Map<String, List<String>> queryCondtion = new HashMap<>();
                Map<String, String> shouldQueryCondtion = new HashMap<>();
                shouldQueryCondtion.put(CommonConstans.QueryStringFrontMoudle, "逆变器");
                queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("日发电量", "月发电量", "年发电量"));
                queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
                List<ESEquipments> result = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class, shouldQueryCondtion);
                dailyPower.updateAndGet(v -> v + keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "日发电量") * CommonConstans.pvGenPoweActor * CommonConstans.pvGenPoweActorDay));
                monthlyPower.updateAndGet(v -> v + keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "月发电量") * CommonConstans.pvGenPoweActornew));
                annualPower.updateAndGet(v -> v + keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "年发电量") * CommonConstans.pvGenPoweActorYear));
            }


        }

        mapdta.put("RSD", dailyPower.get());
        mapdta.put("YFD", monthlyPower.get());
        mapdta.put("NFD", annualPower.get());


//        //总和
//        value.clear();
//        value.add(RSD);
//        value.add(YFD);
//        value.add(NFD);
//        List<? extends Terms.Bucket> lidatesum = commonServiceImpl.getgroupsum(map, "valueF", "equipmentIndexName.keyword", ESEquipments.class);
//
//        for (Terms.Bucket bucket : lidatesum) {
//            Aggregations aggregation = bucket.getAggregations();
//            List<Aggregation> listdata = Objects.nonNull(aggregation) ? aggregation.asList() : null;
//            for (Aggregation agg : listdata) {
//                ParsedSum parsedSum = (ParsedSum) agg;
//                switch (bucket.getKeyAsString()) {
//                    case RSD:
//                        mapdta.put("RSD", Double.valueOf(format2.format(parsedSum.getValue()*CommonConstans.pvGenPoweActor* CommonConstans.pvGenPoweActorDay)));
//                        break;
//                    case YFD:
//                        mapdta.put("YFD", Double.valueOf(format2.format(parsedSum.getValue()*CommonConstans.pvGenPoweActornew)));
//                        break;
//                    case NFD:
//                        mapdta.put("NFD", Double.valueOf(format2.format(parsedSum.getValue()*CommonConstans.pvGenPoweActornew)));
//                        break;
//                    default:
//                        break;
//                }
//            }
//        }
        //计算月完成百分比
        //当前月份 获取
        LocalDate currentDate = LocalDate.now();
        int month = currentDate.getMonthValue();

        QueryWrapper<StationPlan> wrapper = new QueryWrapper<>();
        wrapper.select("ifnull(sum(value), 0) as sum_value");
        wrapper.eq("monthly", month);
        List<Map<String, Object>> list = StationPlanMapper.selectMaps(wrapper);
        Double sumValue = list != null && !list.isEmpty() ? (Double) list.get(0).get("sum_value") : 0;
        //计算年完成百分比
        Double ybfb = sumValue > 0 ? mapdta.get("YFD") / sumValue * 100 : 0;
        ybfb = new BigDecimal(ybfb).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

        mapdta.put("YJHWC", ybfb);
        QueryWrapper<StationPlan> wrapper1 = new QueryWrapper<>();
        wrapper1.select("ifnull(sum(value), 0) as sum_value");
        List<Map<String, Object>> list1 = StationPlanMapper.selectMaps(wrapper1);
        Double sumValuen = list1 != null && !list1.isEmpty() ? (Double) list1.get(0).get("sum_value") : 0;
        Double ybfbn = sumValuen > 0 ? mapdta.get("NFD") / sumValuen * 100 : 0;
        ybfbn = new BigDecimal(ybfbn).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
        mapdta.put("NJHWC", ybfbn);
        try {
            emqKeeper.getMqttClient().publish("qyyxzb/"+s, JSON.toJSONString(mapdta).getBytes(),0,false);
        } catch (MqttException e) {
            e.printStackTrace();
        }
        return mapdta;

    }

    public Double keepFourdecimalPlaces(Double param) {
        return Double.valueOf(String.format("%.4f", param));
    }

    //全国发电趋势
    @Scheduled(cron = "0/10 * * * * ? ")
    public SeriesData getSeriesDataqg(){

        //获取今年当月  日发电趋势
        List<Double> listjn= gettimedate( new Date());
        //获取去年当月  日发电趋势
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.YEAR, -1);
        Date oneYearAgoToday = calendar.getTime();
        List<Double> listqn= gettimedate( oneYearAgoToday);

        Map<String,Object> mapjn=new HashMap<>();
        mapjn.put("data",listjn);
        mapjn.put("name","当前值");
        Map<String,Object> mapqn=new HashMap<>();
        mapqn.put("data",listqn);
        mapqn.put("name","同期值");

        List<Map<String,Object>> list=new ArrayList<>();
        list.add(mapjn);
        list.add(mapqn);
        SeriesData seriesData=new SeriesData();
        seriesData.setSeriesData(list);
        //获取日期
        List<String> listdate=  dayReportnq(new Date());
        seriesData.setAxisData(listdate);
        try {
            emqKeeper.getMqttClient().publish("countryFd", JSON.toJSONString(seriesData).getBytes(),0,false);
        } catch (MqttException e) {
            e.printStackTrace();
        }

        return seriesData;
    }


    //获取区域月日发电量

    @Scheduled(cron = "0/10 * * * * ?")
    private void sendQYFDLMqtt(){
        List<StationCacheInfoDto> listStationCacheInfoDto = commonServiceImpl.getListStationCacheInfoDto();
        Map<String, List<StationCacheInfoDto>> belongAreaList = listStationCacheInfoDto.stream().collect(Collectors.groupingBy(StationCacheInfoDto::getBelongArea));
        for (String s : belongAreaList.keySet()) {
            List<String> ids = belongAreaList.get(s).stream().map(StationCacheInfoDto::getFanGatewayId).collect(Collectors.toList());
            getSeriesDataqy(new Date(),ids,s);
        }
    }


    //区域发电趋势

    public SeriesData getSeriesDataqy( Date date,List<String> gatewayId,String areaCode){

        //获取今年当月  日发电趋势
        List<Double> listjn= gettimedateqy( new Date(),gatewayId);
        //获取去年当月  日发电趋势
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.YEAR, -1);
        Date oneYearAgoToday = calendar.getTime();
        List<Double> listqn= gettimedateqy( oneYearAgoToday,gatewayId);

        Map<String,Object> mapjn=new HashMap<>();
        mapjn.put("data",listjn);
        mapjn.put("name","当前值");
        Map<String,Object> mapqn=new HashMap<>();
        mapqn.put("data",listqn);
        mapqn.put("name","同期值");

        List<Map<String,Object>> list=new ArrayList<>();
        list.add(mapjn);
        list.add(mapqn);
        SeriesData seriesData=new SeriesData();
        seriesData.setSeriesData(list);
        //获取日期
        List<String> listdate=  dayReportnq(new Date());
        seriesData.setAxisData(listdate);
        try {
            emqKeeper.getMqttClient().publish("qy/fdqs/"+areaCode, JSON.toJSONString(seriesData).getBytes(),0,false);
        } catch (MqttException e) {
            e.printStackTrace();
        }

        return seriesData;

    }



     //获取全国月日发电量

     public List<Double> gettimedate( Date date){

         SimpleDateFormat myFmt2=new SimpleDateFormat("yyyyMM");
         String monthy= myFmt2.format(date);
         List<Double> listdate= new ArrayList<>();
         List<String> value=new ArrayList<>();
         value.add(RSD);
         Map<String,List<String>> map=new HashMap<>();
         map.put("equipmentIndexName",value);
         List<String> value1=new ArrayList<>();
         value1.add(monthy);
         map.put("moon",value1);


         List<? extends Terms.Bucket> lidate=  commonServiceImpl.getgroupsum(map,"value" ,"day", ESDailyPowerGeneration.class);

         Map<String,Double>  mapdta=new HashMap<>();
         DecimalFormat format2 = new DecimalFormat("#.0000");

         for (Terms.Bucket bucket : lidate) {
             Aggregations aggregation= bucket.getAggregations();
             List<Aggregation>  listdata= Objects.nonNull(aggregation)?aggregation.asList():null;
             for (Aggregation agg : listdata) {
                 ParsedSum parsedSum  =(ParsedSum)agg;
                 mapdta.put(bucket.getKeyAsString(), Double.valueOf(format2.format(parsedSum.getValue())));
             }
         }
          //组装数据
         List<String> list= dayReport(date);
         for (String s : list) {
             if(mapdta!=null&&mapdta.containsKey(s)){
                 listdate.add(mapdta.get(s));
             }else{
                 listdate.add(0d);
             }
         }
         try {
             emqKeeper.getMqttClient().publish("topic", JSON.toJSONString(listdate).getBytes(),0,false);
         } catch (MqttException e) {
             e.printStackTrace();
         }

         return listdate;


     }



    public List<Double> gettimedateqy( Date date,List<String> gatewayId){

        SimpleDateFormat myFmt2=new SimpleDateFormat("yyyyMM");
        String monthy= myFmt2.format(date);
        List<Double> listdate= new ArrayList<>();
        List<String> value=new ArrayList<>();
        value.add(RSD);
        Map<String,List<String>> map=new HashMap<>();
        map.put("equipmentIndexName",value);
        map.put("gatewayId", gatewayId);
        List<String> value1=new ArrayList<>();
        value1.add(monthy);
        map.put("moon",value1);

        List<? extends Terms.Bucket> lidate=  commonServiceImpl.getgroupsum(map,"value" ,"day",ESDailyPowerGeneration.class);

        Map<String,Double>  mapdta=new HashMap<>();
        DecimalFormat format2 = new DecimalFormat("#.0000");

        for (Terms.Bucket bucket : lidate) {
            Aggregations aggregation= bucket.getAggregations();
            List<Aggregation>  listdata= Objects.nonNull(aggregation)?aggregation.asList():null;
            for (Aggregation agg : listdata) {
                ParsedSum parsedSum  =(ParsedSum)agg;
                mapdta.put(bucket.getKeyAsString(), Double.valueOf(format2.format(parsedSum.getValue())));
            }
        }
        //组装数据
        List<String> list= dayReport(date);
        for (String s : list) {
            if(mapdta!=null&&mapdta.containsKey(s)){
                listdate.add(mapdta.get(s));
            }else{
                listdate.add(0d);
            }
        }



        return listdate;

    }









    public List<String> dayReport(Date month) {

        List<String> list=new ArrayList<>();

        Calendar cal = Calendar.getInstance();
        cal.setTime(month);//month 为指定月份任意日期
        int year = cal.get(Calendar.YEAR);
        int m = cal.get(Calendar.MONTH)+1;
        int dayNumOfMonth = DateUtil.getDaysByYearMonth(year, m);
        cal.set(Calendar.DAY_OF_MONTH, 1);// 从一号开始

        for (int i = 0; i < dayNumOfMonth; i++ ) {

            list.add(String.valueOf(i+1));
        }

        return list;
    }

    public List<String> dayReportnq (Date month) {

        List<String> list=new ArrayList<>();

        Calendar cal = Calendar.getInstance();
        cal.setTime(month);//month 为指定月份任意日期
        int year = cal.get(Calendar.YEAR);
        int m = cal.get(Calendar.MONTH)+1;
        int dayNumOfMonth = DateUtil.getDaysByYearMonth(year, m);
        cal.set(Calendar.DAY_OF_MONTH, 1);// 从一号开始

        for (int i = 0; i < dayNumOfMonth; i++ ) {

            list.add(m+"-"+String.valueOf(i+1));
        }
        try {
            emqKeeper.getMqttClient().publish("topic", JSON.toJSONString(list).getBytes(),0,false);
        } catch (MqttException e) {
            e.printStackTrace();
        }

        return list;

    }

}