package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ColModel;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.DataGridMock;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.EquipAlarmEventDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipAlarmEvent;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.EquipAlarmEventMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service
public class EquipAlarmEventServiceImpl extends BaseService<EquipAlarmEventDto, EquipAlarmEvent, EquipAlarmEventMapper> {

    @Autowired
    EquipAlarmEventMapper equipAlarmEventMapper;
    @Autowired
    StationBasicMapper stationBasicMapper;

    public ResultsData getEventByEquipIndex(String gatewayId, int current, int size, String equipIndex, String frontModule) {
        List<EquipAlarmEvent> equipAlarmEvents = new ArrayList<>();
        LambdaQueryWrapper<EquipAlarmEvent> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(EquipAlarmEvent::getEquipIndex, equipIndex);
        queryWrapper.eq(EquipAlarmEvent::getGatewayId, gatewayId);
        queryWrapper.eq(EquipAlarmEvent::getFrontModule, frontModule);
        queryWrapper.orderByDesc(EquipAlarmEvent::getCreatedTime);
        equipAlarmEvents = equipAlarmEventMapper.selectList(queryWrapper);

        DataGridMock DataGridMock = new DataGridMock(current, equipAlarmEvents.size(), false, current, equipAlarmEvents.subList((current - 1) * size, current * size));
        ColModel colModelEventMovement = new ColModel("equipName", "equipName", "设备名", "设备名", "dataGrid", "equipName");
        ColModel colModelStationName = new ColModel("alarmDesc", "alarmDesc", "事件描述", "事件描述", "dataGrid", "alarmDesc");
        ColModel colModelEventDesc = new ColModel("createdTime", "createdTime", "告警时间", "告警时间", "dataGrid", "createdTime");
        List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelEventDesc);
        ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
        return resultsData;
    }
}
