package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 换流站告警日统计
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireAlarmDayStatisticsDto", description = "换流站告警日统计")
public class FireSignalDayStatisticsDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "统计日期")
    private Date collectDate;

    @ApiModelProperty(value = "上报次数")
    private Integer reportTimes;

    @ApiModelProperty(value = "信号类型")
    private String signalType;

    @ApiModelProperty(value = "信号类型名称")
    private String signalTypeName;

    @ApiModelProperty(value = "是否为告警信号数据")
    private Boolean isAlarm;


}
