package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPvDevice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDeviceDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDeviceImport;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.HouseholdPvDeviceServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 户用光伏设备表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@RestController
@Api(tags = "户用光伏设备表Api")
@RequestMapping(value = "/household-pv-device")
public class HouseholdPvDeviceController extends BaseController {

	@Autowired
	HouseholdPvDeviceServiceImpl householdPvDeviceServiceImpl;

	/**
	 * 新增户用光伏设备表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏设备表", notes = "新增户用光伏设备表")
	public ResponseModel<HouseholdPvDeviceDto> save(@RequestBody HouseholdPvDeviceDto model) {
		model = householdPvDeviceServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏设备表", notes = "根据sequenceNbr更新户用光伏设备表")
	public ResponseModel<HouseholdPvDeviceDto> updateBySequenceNbrHouseholdPvDevice(
			@RequestBody HouseholdPvDeviceDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.updateWithModel(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/removeMessage")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏设备表", notes = "根据sequenceNbr删除户用光伏设备表")
	public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏设备表", notes = "根据sequenceNbr查询单个户用光伏设备表")
	public ResponseModel<HouseholdPvDeviceDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "户用光伏设备表分页查询", notes = "户用光伏设备表分页查询")
	public ResponseModel<IPage<HouseholdPvDevice>> queryForPage(@RequestParam(value = "current") int current,
																@RequestParam(value = "size") int size, @RequestParam("objId") Long objId) {
		Page<HouseholdPvDevice> page = new Page<HouseholdPvDevice>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.queryForHouseholdPvDevicePage(page, objId));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏设备表列表全部数据查询", notes = "户用光伏设备表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HouseholdPvDeviceDto>> selectForList() {
		return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.queryForHouseholdPvDeviceList());
	}

	@GetMapping(value = "/exportTemplates")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "模板下载", notes = "模板下载")
	public void exportTemplates(HttpServletResponse response) {
		householdPvDeviceServiceImpl.exportTemplates(response);
	}

	@PostMapping(value = "/import")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "导入", notes = "导入")
	public ResponseModel<Object> importData(@RequestPart("file") MultipartFile multipartFile,
			@RequestParam(value = "householdPvId", required = true) String householdPvId) {
		List<HouseholdPvDeviceImport> list;
		try {
			list = ExcelUtil.readFirstSheetExcel(multipartFile, HouseholdPvDeviceImport.class, 2);
			householdPvDeviceServiceImpl.importData(list, Long.parseLong(householdPvId));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ResponseHelper.buildResponse("success");
	}
}
