package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.util.FileUtil;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDeviceDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDeviceImport;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPvDevice;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.HouseholdPvDeviceMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvDeviceService;

/**
 * 户用光伏设备表服务实现类
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Service
public class HouseholdPvDeviceServiceImpl
		extends BaseService<HouseholdPvDeviceDto, HouseholdPvDevice, HouseholdPvDeviceMapper>
		implements IHouseholdPvDeviceService {

	@Autowired
	HouseholdPvDeviceMapper householdPvDeviceMapper;

	/**
	 * 分页查询
	 */
	public IPage<HouseholdPvDevice> queryForHouseholdPvDevicePage(Page<HouseholdPvDevice> page, Long objId) {
		LambdaQueryWrapper<HouseholdPvDevice> lambda = new QueryWrapper<HouseholdPvDevice>().lambda();
		lambda.eq(HouseholdPvDevice :: getHouseholdPvId, objId);
		lambda.orderByDesc(HouseholdPvDevice::getRecDate);
		return householdPvDeviceMapper.selectPage(page, lambda);
	}

	/**
	 * 列表查询 示例
	 */
	public List<HouseholdPvDeviceDto> queryForHouseholdPvDeviceList() {
		return this.queryForList("", false);
	}

	@Override
	public void exportTemplates(HttpServletResponse response) {
		FileUtil.downloadResource("户用光伏-设备导入模板.xlsx", "templates/户用光伏-设备导入模板.xlsx", response);
	}

	@Override
	public void importData(List<HouseholdPvDeviceImport> list, long householdPvId) {
		List<HouseholdPvDevice> dataList = new ArrayList<>();
		for (HouseholdPvDeviceImport householdPvDeviceImport : list) {
			HouseholdPvDevice householdPvDevice = new HouseholdPvDevice();
			BeanUtils.copyProperties(householdPvDeviceImport, householdPvDevice);
			householdPvDevice.setHouseholdPvId(householdPvId);
			dataList.add(householdPvDevice);
		}
		this.baseMapper.insertAndUpdate(dataList);
	}
}