package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.vo.PersonVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 人员归属信息 Mapper 接口
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface PersonAscriptionMapper extends BaseMapper<PersonAscription> {
	List<PersonVo> getUsers(@Param("roleIds") Set<String> roleIds, @Param("userListIds") List<Long> userListIds,
			@Param("projectId") Long projectId);

	/**
	 * 项目关联的施工人员
	 * 
	 * @param personId
	 * @return
	 */
	List<Long> projectPerson(Long personId);

	/**
	 * 项目关联的分包商
	 * 
	 * @param personId
	 * @return
	 */
	List<Long> projectCompany(Long personId);

	List<PersonVo> getUsersByDept(@Param("roleIds") Set<String> roleIds, @Param("companyId") Long companyId,
			@Param("departmentId") Long departmentId, @Param("projectId") Long projectId);
}
