package com.yeejoin.precontrol.common.utils.hk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.precontrol.common.constant.Const;
import com.yeejoin.precontrol.common.entity.hk.model.vo.HKResultVo;
import com.yeejoin.precontrol.common.enums.media.ResultMsg;

/**
 * @Author: songLei
 * @Description: 统一数据返回
 * @Date: 2021/4/30 10:26
 * @Version: 1.0
 */
public class ReturnUnifiedData {
    /**
     * @Method
     * @Author songLei
     * @Version  1.0
     * @Description 返回同一的海康接口数据
     * @Return Object
     * @Date 2021/4/30 10:27
     */
    public static Object returnData(String result){
        JSONObject obj = JSON.parseObject(result);
        HKResultVo resultVo = JSON.toJavaObject(obj, HKResultVo.class);
        if (resultVo.getCode().equals(Const.CODE_ZERO)) {
            return resultVo.getData();
        }
        return ResultMsg.CALL_API_FAIL.getMsg();
    }
}
