package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 焊口信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_weld")
public class Weld extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 焊口编码
     */
	@TableField("code")
    private String code;

    /**
     * 项目id
     */
	@TableField("project_id")
    private Long projectId;

    /**
     * 安装单位id
     */
	@TableField("install_company")
    private Long installCompany;

    /**
     * 所在地
     */
	@TableField("region")
    private String region;

    /**
     * 赋码状态(0未赋码，1赋码成功)
     */
	@TableField("coding_status")
    private String codingStatus;

    /**
     * 赋码方式
     */
	@TableField("coding_method")
    private String codingMethod;

    /**
     * 监检状态
     */
	@TableField("super_inspec_status")
    private String superInspecStatus;

    /**
     * 赋码日期
     */
	@TableField("coding_date")
    private Date codingDate;

    /**
     *经度
     */
    @TableField("longitude")
    private String longitude;

    /**
     *纬度
     */
    @TableField("latitude")
    private String latitude;

    /**
     *焊口状态(0-进行中，1-已完成)
     */
    @TableField("status")
    private Integer status;

    /**
     *经度
     */
    @TableField("voltage_longitude")
    private String voltageLongitude;

    /**
     *纬度
     */
    @TableField("voltage_latitude")
    private String voltageLatitude;


}
