package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProjectInitiationEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.TaskTypeEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.TaskDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNotice;
import com.yeejoin.amos.boot.module.ugp.api.entity.Task;
import com.yeejoin.amos.boot.module.ugp.api.mapper.TaskMapper;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.OrgServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.TaskServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jdk.nashorn.internal.runtime.regexp.joni.EncodingHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 监检任务表
 *
 * @author duanwei
 * @date 2022-10-19
 */
@RestController
@Api(tags = "监检任务表Api")
@RequestMapping(value = "/tz-ugp-task")
public class TaskController {

  @Autowired
  TaskServiceImpl iTzUgpTaskService;

  @Autowired
  OrgServiceImpl orgService;
  @Autowired
    TaskMapper taskMapper;


    /**
    * 新增监检任务表
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增监检任务表", notes = "新增监检任务表")
    public boolean saveTzUgpTask(HttpServletRequest request, @RequestBody Task task){
    return iTzUgpTaskService.save(task);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iTzUgpTaskService.removeById(id);
    }




    /**
    * 修改监检任务表
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改监检任务表", notes = "修改监检任务表")
    public boolean updateByIdTzUgpTask(HttpServletRequest request, @RequestBody Task task){
    return iTzUgpTaskService.updateById(task);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public Task selectById(HttpServletRequest request, @PathVariable Long id){
      return iTzUgpTaskService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<Task> listPage(String pageNum, String pageSize,
                              Task task){

    Page<Task> pageBean;
    QueryWrapper<Task> tzUgpTaskQueryWrapper = new QueryWrapper<>();
    Class<? extends Task> aClass = task.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(task);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(task);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(task);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(task);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(task);
                tzUgpTaskQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<Task> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iTzUgpTaskService.page(pageBean, tzUgpTaskQueryWrapper);
    return page;
  }

    /**
     * 获取当前登录人的所有任务列表
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @RequestMapping(value = "/getTaskList", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取当前登录人的所有任务列表", notes = "获取当前登录人的所有任务列表")
    @BusinessIdentify
  public ResponseModel<IPage<Task>> getTaskList(@RequestParam(value = "status",required = false) String type,Long current,Long size){
        Long unitId = orgService.getReginParams().getBusinessInfo().getCompanySequenceNbr();
        IPage<Task> page = new Page(current,size);
//       LambdaQueryWrapper<Task> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(Task::getUnitId,unitId);
//        if(!ValidationUtil.isEmpty(type)){
//            wrapper.eq(Task::getStatus,type);
//        }
//        iTzUgpTaskService.page(page, wrapper);
        Integer status = null;
        if(!ValidationUtil.isEmpty(type)) {
            if("true".equals(type)){
                status = 1;
            }else {
                status = 0;
            }
        }

        page = taskMapper.getTask(page, status, unitId);
        List<Task> list = page.getRecords();
        for(Task task : list){
            if(task.getStatus() == 1){
                if(!ValidationUtil.isEmpty(task.getExtendId())){
                    if(task.getExtendId()!=-1L) {
                        task.setSourceId(task.getExtendId());
                    }
                }
            }
        }

        return ResponseHelper.buildResponse(page);
  }

    /**
     * 获取当前登录人的所有任务统计
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
  @RequestMapping(value = "/getTaskCount", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "获取当前登录人的所有任务统计", notes = "获取当前登录人的所有任务统计")
  public ResponseModel<Map> getCount(){
        List myTask = new ArrayList();
        List todyCompletedTask = new ArrayList();
        Long unitId = orgService.getReginParams().getBusinessInfo().getCompanySequenceNbr();
        LambdaQueryWrapper<Task> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Task::getUnitId,unitId);
        if(true){
            wrapper.eq(Task::getTaskType,false);
            myTask = iTzUgpTaskService.list(wrapper);
        }else {
            wrapper.eq(Task::getTaskType,true);
            todyCompletedTask = iTzUgpTaskService.list(wrapper);
        }

        Map<String,String> map = new HashMap();
        map.put("myTask", String.valueOf(myTask.size()));
        map.put("todyCompletedTask", String.valueOf(todyCompletedTask.size()));
        return ResponseHelper.buildResponse(map);
  }

}


