package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FireChemicalDto;
import com.yeejoin.amos.boot.module.common.api.entity.FireChemical;
import com.yeejoin.amos.boot.module.common.api.mapper.FireChemicalMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFireChemicalService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
/**
* 危化品服务实现类
*
* @author system_generator
* @date 2021-06-29
*/
@Service
public class FireChemicalServiceImpl extends BaseService<FireChemicalDto,FireChemical,FireChemicalMapper> implements IFireChemicalService {
        /**
         * 分页查询
         */
        @Override
        public Page<FireChemicalDto> queryForFireChemicalPage(Page<FireChemicalDto> page,   @Condition(Operator.like) String casNo, @Condition(Operator.like)String formula, @Condition(Operator.like)String name, String typeCode,boolean isDelete)   {
                if("-1".equals(typeCode)) { // bug 2673 选择 -1 时候没有查出所有危化品处理 by kongfm
                        typeCode = null;
                }
                // BUG 2123 日常管理>辅助资源>危化品，危化品列表数据按创建时间倒序排列 by litw start
                // 危化品按时间倒叙排列add rec_date 2021-09-08 by kongfm
           return this.queryForPage(page, "rec_date", false,casNo, formula, name,  typeCode, isDelete);
        }

        /**
         * 列表查询 示例
         */
        public List<FireChemicalDto> queryForFireChemicalList(@Condition(Operator.like) String casNo, @Condition(Operator.like)String formula, @Condition(Operator.like)String name, String typeCode,boolean isDelete)   {
                return this.queryForList("" , false,casNo, formula, name,  typeCode, isDelete);
        }
        /**
         * 删除
         * */
        public Boolean updateisDelete( List sequenceNbr)   {
        	
        	return this.update(new UpdateWrapper<FireChemical>().in("sequence_nbr", sequenceNbr).set("is_delete", 1));         	
       }
}
