package com.yeejoin.equipmanage.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.dto.MaintenanceResourceDto;
import com.yeejoin.equipmanage.common.entity.MaintenanceResource;
import com.yeejoin.equipmanage.common.entity.MaintenanceResourceData;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.vo.MaintenanceResourceDataVo;
import com.yeejoin.equipmanage.common.vo.MaintenanceResourceVo;
import com.yeejoin.equipmanage.service.IMaintenanceResourceService;

import io.swagger.annotations.ApiOperation;

/**
 * 维保设施资源树Controller
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
@RestController
@RequestMapping("/maintenanceResource")
public class MaintenanceResourceController extends AbstractBaseController {
    @Autowired
    private IMaintenanceResourceService maintenanceResourceService;

    /**
     * 查询维保设施资源树列表
     */
    @GetMapping("/list")
    public ResponseModel list(MaintenanceResource maintenanceResource) {
//        startPage();
        List<MaintenanceResource> list = maintenanceResourceService.selectMaintenanceResourceList(maintenanceResource);
        return CommonResponseUtil.success(list);
    }

    /**
     * 获取维保设施资源树详细信息
     */
    @GetMapping(value = "/{id}")
    public ResponseModel getInfo(@PathVariable("id") Long id) {
        return CommonResponseUtil.success(maintenanceResourceService.selectMaintenanceResourceById(id));
    }

    /**
     * 新增维保设施资源树
     */
    @PostMapping
    public ResponseModel add(@RequestBody MaintenanceResource maintenanceResource) {
        return CommonResponseUtil.success(maintenanceResourceService.insertMaintenanceResource(maintenanceResource));
    }

    /**
     * 修改维保设施资源树
     */
    @PutMapping
    public ResponseModel edit(@RequestBody MaintenanceResource maintenanceResource) {
        return CommonResponseUtil.success(maintenanceResourceService.updateMaintenanceResource(maintenanceResource));
    }

    /**
     * 删除维保设施资源树
     */
    @DeleteMapping("/{ids}")
    public ResponseModel remove(@PathVariable Long[] ids) {
        return CommonResponseUtil.success(maintenanceResourceService.deleteMaintenanceResourceByIds(ids));
    }

    /**
     * 获取维保设施资源树
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("获取维保设施资源树")
    @GetMapping(value = "/tree")
    public List<MaintenanceResourceDto> getMaintenanceResourceTree() {
        return maintenanceResourceService.getMaintenanceResourceTree(getAppKey(), getProduct(), getToken());
    }

    /**
     * 获取维保设施资源树
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("根据实例ID，获取维保设施资源树")
    @GetMapping(value = "/findTreeById")
    public List<MaintenanceResourceDto> findTreeByType(Long id) {
        return maintenanceResourceService.findTreeById(id);
    }

    /**
     * 获取维保设施资源树
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("获取维保设施组合树")
    @GetMapping(value = "/combineTree")
    public List<MaintenanceResourceDto> combineTree() {
        return maintenanceResourceService.combineTree(getAppKey(), getProduct(), getToken());
    }

    /**
     * 获取维保设施资源树
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("获取维保设施组合树")
    @GetMapping(value = "/combineData")
    public List<MaintenanceResourceData> combineData() {
        return maintenanceResourceService.combineData(getAppKey(), getProduct(), getToken());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询维保单位、业主单位信息", notes = "查询维保单位、业主单位信息")
    @GetMapping(value = "/companyList")
    public ResponseModel selectCompanyList() {
        return CommonResponseUtil.success(maintenanceResourceService.selectCompanyList(getAppKey(), getProduct(), getToken()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("获取维保设施组合数据分页")
    @GetMapping(value = "/combineDataPage")
    public IPage<MaintenanceResourceDataVo> getAssociatedEquipmentByPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(required = false) Long fireFightSysId,
            @RequestParam(required = false) String fireFacilityName,
            @RequestParam(required = false) List<Long> buildingId,
            @RequestParam(required = false) Long fireFacilityId,
            @RequestParam(required = false) String classifyId) {
        Page page = new Page();
        page.setCurrent(current);
        if (-1 == size) {
            page.setSize(Integer.MAX_VALUE);
        } else {
            page.setSize(size);
        }
        return maintenanceResourceService.combineDataPage(page, fireFightSysId, fireFacilityId, fireFacilityName, classifyId, buildingId, getAppKey(), getProduct(), getToken());
    }

    /**
     * 获取移动端维保设施消防系统分页
     * @param current
     * @param size
     * @param type  数据过滤（1-维保，2-业主，3-系统，4-分类）
     * @param id    树形父级ID（维保、业主、系统、分类）
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("获取移动端维保设施消防系统分页")
    @GetMapping(value = "/getFireFightSysPage")
    public IPage<MaintenanceResourceVo> getFireFightSysPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(required = false) Long maintenanceCompanyId,
            @RequestParam(required = false) Long ownerUnitId,
            @RequestParam(required = false) Long fireFightSysId,
            @RequestParam(required = false) Integer type) {
        Page page = new Page();
        page.setCurrent(current);
        if (-1 == size) {
            page.setSize(Integer.MAX_VALUE);
        } else {
            page.setSize(size);
        }
        return maintenanceResourceService.getFireFightSysPage(page, maintenanceCompanyId, ownerUnitId, fireFightSysId, type);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取维保设施移动端业主单位下拉列表", notes = "获取维保设施移动端业主单位下拉列表")
    @GetMapping(value = "/selectOwnerUnitList")
    public ResponseModel selectOwnerUnitList(@RequestParam(required = false) Integer type, @RequestParam(required = false) Long id) {
        return CommonResponseUtil.success(maintenanceResourceService.selectOwnerUnitList(id, type));
    }

}
