package com.yeejoin.equipmanage.service.impl;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.http.HttpServletResponse;

import com.yeejoin.equipmanage.common.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.equipmanage.common.datasync.entity.FireEquipmentFireAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecific;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.dto.AlarmDTO;
import com.yeejoin.equipmanage.common.entity.dto.EquipSpecificAlarmDTO;
import com.yeejoin.equipmanage.common.entity.vo.VideoVO;
import com.yeejoin.equipmanage.common.enums.AlarmGridColumnEnum;
import com.yeejoin.equipmanage.common.enums.AlarmTypeEnum;
import com.yeejoin.equipmanage.common.enums.ConfirmAlamEnum;
import com.yeejoin.equipmanage.common.enums.EquipmentDataEnum;
import com.yeejoin.equipmanage.common.utils.CommonPageInfoParam;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.mapper.ConfirmAlarmMapper;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmLogMapper;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmMapper;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificMapper;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import com.yeejoin.equipmanage.service.IEquipmentDetailService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificIndexSerivce;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivce;
import com.yeejoin.equipmanage.service.IVideoService;

/**
 * @author DELL
 */
@Service
public class EquipmentSpecificAlarmServiceImpl extends ServiceImpl<EquipmentSpecificAlarmMapper, EquipmentSpecificAlarm> implements IEquipmentSpecificAlarmService {

    @Autowired
    ConfirmAlarmMapper confirmAlarmMapper;

    @Autowired
    EquipmentSpecificAlarmMapper equipmentSpecificAlarmMapper;

    @Autowired
    EquipmentSpecificAlarmLogMapper equipmentSpecificAlarmLogMapper;

    @Autowired
    EquipmentSpecificMapper equipmentSpecificMapper;

    @Autowired
    IEquipmentSpecificSerivce equipmentSpecificService;

    @Autowired
    IEquipmentDetailService iEquipmentDetailService;

    @Autowired
    IEquipmentSpecificIndexSerivce equipmentSpecificIndexService;

    @Autowired
    FireFightingSystemMapper fireFightingSystemMapper;
    
    @Autowired
    private IVideoService videoService;

    @Override
    public void handleExport(HttpServletResponse response, List<Long> ids, String alarmType) {
        CommonPageInfoParam param = new CommonPageInfoParam();
        param.setAlarmType(alarmType);
        List<HashMap<String, Object>> list = this.baseMapper.getAlarmList(param);
        List<EquipmentAlarmDownloadVO> equipmentDownloads = handleExportData(ids, list);
        if (0 == list.size()) {
            throw new RuntimeException("导出数据列表无数据！");
        }
        ExcelUtil.createTemplate(response, "设备告警信息", "设备告警信息", equipmentDownloads, EquipmentAlarmDownloadVO.class, null,
        		false);
       
    }

    public List<EquipmentAlarmDownloadVO> handleExportData(List<Long> ids, List<HashMap<String, Object>> list) {
        List<EquipmentAlarmDownloadVO> equipmentDownloads = new ArrayList<>();
        if (!ObjectUtils.isEmpty(ids) && 0 < ids.size()) {
            if (0 < list.size()) {
                list.forEach(alarm -> {
                    ids.forEach(id -> {
                        EquipmentAlarmDownloadVO alarmDownloadVO = new EquipmentAlarmDownloadVO();
                        if ((alarm.get("id").toString()).equals(id.toString())) {
//                            alarmDownloadVO.setId((Long) alarm.get("id"));
                            alarmDownloadVO.setAlarmType(AlarmTypeEnum.GZGJ.getCode().equals(alarm.get("type").toString())
                                    ? AlarmTypeEnum.GZGJ.getType() : AlarmTypeEnum.HZGJ.getType());
                            alarmDownloadVO.setEquipName(alarm.get("fireEquipmentName").toString());
                            alarmDownloadVO.setAlarmContent(alarm.get("alarmContent").toString());
                            alarmDownloadVO.setEquipCode(StringUtil.isNotEmpty(alarm.get("fireEquipmentCode")) ? alarm.get("fireEquipmentCode").toString() : "");
                            alarmDownloadVO.setAlarmPosition(StringUtil.isNotEmpty(alarm.get("warehouseStructureName")) ? alarm.get("warehouseStructureName").toString() : "");
                            alarmDownloadVO.setProtectObj(StringUtil.isNotEmpty(alarm.get("equipmentName")) ? alarm.get("equipmentName").toString() : "");
                            alarmDownloadVO.setAlarmTime(StringUtil.isNotEmpty(alarm.get("createDate")) ? alarm.get("createDate").toString().replace("T", " "):"");
                            alarmDownloadVO.setCleanStatus(alarm.get("cleanStatus").toString());
                            // 处理状态、处理类型无业务字段，后期业务功能实现之后需在此处返回相应字段
                            alarmDownloadVO.setHandleStatus(String.valueOf(alarm.get("handleStatus")));
                            alarmDownloadVO.setHandleType(ConfirmAlamEnum.getTypeByCode(String.valueOf(alarm.get("handleType"))));
                            alarmDownloadVO.setResolveResult(StringUtil.isNotEmpty(alarm.get("resolveResult")) ? alarm.get("resolveResult").toString() : "");
                            alarmDownloadVO.setConfirmDate(StringUtil.isNotEmpty(alarm.get("confirmDate")) ?alarm.get("confirmDate").toString().replace("T", " ") : "");
                            alarmDownloadVO.setAlarmReason(StringUtil.isNotEmpty(alarm.get("alarmReason")) ? alarm.get("alarmReason").toString() : "");
                            equipmentDownloads.add(alarmDownloadVO);
                        }
                    });
                });
            } else {
                return null;
            }
        } else {
            if (0 < list.size()) {
                list.forEach(alarm -> {
                    EquipmentAlarmDownloadVO alarmDownloadVO = new EquipmentAlarmDownloadVO();
//                    alarmDownloadVO.setId((Long) alarm.get("id"));
                    alarmDownloadVO.setAlarmType(AlarmTypeEnum.GZGJ.getCode().equals(alarm.get("type").toString())
                            ? AlarmTypeEnum.GZGJ.getType() : AlarmTypeEnum.HZGJ.getType());
                    alarmDownloadVO.setEquipName(alarm.get("fireEquipmentName").toString());
                    alarmDownloadVO.setAlarmContent(alarm.get("alarmContent").toString());
                    alarmDownloadVO.setEquipCode(StringUtil.isNotEmpty(alarm.get("fireEquipmentCode")) ? alarm.get("fireEquipmentCode").toString() : "");
                    alarmDownloadVO.setAlarmPosition(StringUtil.isNotEmpty(alarm.get("warehouseStructureName")) ? alarm.get("warehouseStructureName").toString() : "");
                    alarmDownloadVO.setProtectObj(StringUtil.isNotEmpty(alarm.get("equipmentName")) ? alarm.get("equipmentName").toString() : "");
                    alarmDownloadVO.setAlarmTime(StringUtil.isNotEmpty(alarm.get("createDate")) ? alarm.get("createDate").toString().replace("T", " "):"");
                    alarmDownloadVO.setCleanStatus(alarm.get("cleanStatus").toString());
                    // 处理状态、处理类型无业务字段，后期业务功能实现之后需在此处返回相应字段
                    alarmDownloadVO.setHandleStatus(String.valueOf(alarm.get("handleStatus")));
                    alarmDownloadVO.setHandleType(ConfirmAlamEnum.getTypeByCode(String.valueOf(alarm.get("handleType"))));
                    alarmDownloadVO.setResolveResult(StringUtil.isNotEmpty(alarm.get("resolveResult")) ? alarm.get("resolveResult").toString() : "");
                    alarmDownloadVO.setConfirmDate(StringUtil.isNotEmpty(alarm.get("confirmDate")) ?alarm.get("confirmDate").toString().replace("T", " ") : "");
                    alarmDownloadVO.setAlarmReason(StringUtil.isNotEmpty(alarm.get("alarmReason")) ? alarm.get("alarmReason").toString() : "");
                    equipmentDownloads.add(alarmDownloadVO);
                });
            } else {
                return null;
            }
        }
        return equipmentDownloads;
    }

    @Override
    public Page<Map<String, Object>> listPage(CommonPageInfoParam param) {
        Page result = new Page<>(param.getPageNumber(), param.getPageSize());
        Page<Map<String, Object>> resultPage = this.baseMapper.page(result, param);
        if (resultPage.getTotal() > 0) {
            for (Map<String, Object> x : resultPage.getRecords()) {
                Object type = x.get("type");
                if (AlarmTypeEnum.HZGJ.getCode().equals(type) || AlarmTypeEnum.GZGJ.getCode().equals(type)) {
                    x.put("typeCode", type);
                    x.put("type", AlarmTypeEnum.getTypeByCode(String.valueOf(type)));
                }
                LocalDateTime createDate = (LocalDateTime) x.get("createDate");
                x.put("createDate", Date.from(createDate.atZone(ZoneId.systemDefault()).toInstant()));
                x.put("handleType", ConfirmAlamEnum.getTypeByCode(String.valueOf(x.get("handleType"))));
                x.put("fireEquipmentName", x.get("fireEquipmentName"));
            }
        }
        return resultPage;
    }

    @Override
    public org.springframework.data.domain.Page<AlarmListDataVO> listAlarmsPage(CommonPageInfoParam param) {
        Page page = new Page(param.getPageNumber(), param.getPageSize());
        Page<Map<String, Object>> mybatisResult = this.baseMapper.pageAlarmsInfo(page, param);
        List<AlarmListDataVO> res = new ArrayList<>();
        if (mybatisResult.getSize() > 0) {
            mybatisResult.getRecords().forEach(x -> {
                AlarmListDataVO dataVO = new AlarmListDataVO();
                try {
                    dataVO.setAlarmTime(DateUtils.dateParse(String.valueOf(x.get("createDate")),DateUtils.DATE_TIME_T_PATTERN));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                dataVO.setAlarmEquip(String.valueOf(x.get("fireEquipmentName")));
                Object type = x.get("type");
                if (AlarmTypeEnum.HZGJ.getCode().equals(type) || AlarmTypeEnum.GZGJ.getCode().equals(type)
                        || AlarmTypeEnum.PB.getCode().equals(type)) {
                    dataVO.setAlarmType(AlarmTypeEnum.getTypeByCode(String.valueOf(type)));
                }
                dataVO.setType(String.valueOf(x.get("type")));
                dataVO.setAlarmInfo(x.get("fireEquipmentName") + dataVO.getAlarmType());
                dataVO.setEquipSpeId(Long.valueOf(String.valueOf(x.get("fireEquipmentId"))));
                dataVO.setAlarmId(Long.valueOf(String.valueOf(x.get("alarmId"))));
                dataVO.setAlarmTypeCode(String.valueOf(x.get("fireEquipmentSpecificIndexKey")));
                dataVO.setCleanStatus(String.valueOf(x.get("cleanStatus")));
                dataVO.setCleanStatusVal(String.valueOf(x.get("cleanStatusVal")));
                res.add(dataVO);
            });
        }
        //前端原有数据结构已经写好，所以分页又有mybatisplus(起始页为1)分页转为PageImpl（起始页为0）
        param.setPageNumber(param.getPageNumber() - 1);
        return new PageImpl<>(res, param, mybatisResult.getTotal());
    }

    @Override
    public org.springframework.data.domain.Page<TopographyAlarmVo> listAlarmsPageForTopography(CommonPageInfoParam param) {
        Page page = new Page(param.getPageNumber(), param.getPageSize());
        Page<Map<String, Object>> mybatisResult = this.baseMapper.pageAlarmsInfo(page, param);
        List<TopographyAlarmVo> res = new ArrayList<>();
        if (mybatisResult.getSize() > 0) {
            mybatisResult.getRecords().forEach(x -> {
                TopographyAlarmVo dataVO = new TopographyAlarmVo();
                try {
                    dataVO.setCreateDate(DateUtils.dateParse(String.valueOf(x.get("createDate")),DateUtils.DATE_TIME_T_PATTERN));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                dataVO.setFireEquipmentSpecificIndexName(String.valueOf(x.get("fireEquipmentSpecificIndexName")));
                dataVO.setFireEquipmentName(String.valueOf(x.get("fireEquipmentName")));
                dataVO.setWarehouseStructureName(String.valueOf(x.get("warehouseStructureName")));
                dataVO.setEquipmentName(null == x.get("equipmentName") ? null : String.valueOf(x.get("equipmentName")));
                dataVO.setHandleStatus(String.valueOf(x.get("handleStatus")));
                dataVO.setStatus(String.valueOf(x.get("status")));
                Object type = x.get("type");
                if (AlarmTypeEnum.HZGJ.getCode().equals(type) || AlarmTypeEnum.GZGJ.getCode().equals(type)
                        || AlarmTypeEnum.PB.getCode().equals(type)) {
                    dataVO.setAlarmType(AlarmTypeEnum.getTypeByCode(String.valueOf(type)));
                }
                dataVO.setAlarmContent(x.get("fireEquipmentName") + dataVO.getAlarmType());
                dataVO.setHandleType(null == x.get("handleType") ? null : String.valueOf(x.get("handleType")));
                res.add(dataVO);
            });
        }
        param.setPageNumber(param.getPageNumber() - 1);
        return new PageImpl<>(res, param, mybatisResult.getTotal());
    }

    @Override
    public Map<String, Object> getSpecificInfoById(Long id) {
        Map<String, Object> map = new HashMap<>();
        EquipmentSpecificAlarmLog alarm = equipmentSpecificAlarmLogMapper.selectById(id);
        EquipmentSpecific equipmentSpecific = equipmentSpecificService.getById(alarm.getEquipmentSpecificId());
        Map<String, Object> equipmentSpecificInfo = equipmentSpecificMapper.getEquipSpeInfo(alarm.getEquipmentSpecificId());
//        equipmentSpecific.setFullqrCode("01#" + equipmentSpecific.getQrCode());
//        EquipmentDetail equipmentDetail = iEquipmentDetailService.getOneById(equipmentSpecific.getEquipmentDetailId());
        List<Video> videos = equipmentSpecificIndexService.getVideoByEquipmentSecificId(alarm.getEquipmentSpecificId());
        List<VideoVO> videoVOS = new ArrayList<>();
        videos.forEach(x -> {
            VideoVO video = new VideoVO();
            video.setName(x.getName());
            video.setTokens(x.getToken());
            video.setUrl(x.getUrl());
            video.setUrl(videoService.getVideoUrl(x.getName(), x.getPresetPosition(), x.getUrl(), x.getCode()));
            video.setIp(x.getIp());
            video.setPort(x.getPort());
            video.setCode(x.getCode());
            video.setPresetPosition(x.getPresetPosition());
            videoVOS.add(video);
        });
        List<Map<String, Object>> list = this.baseMapper.getProObject(alarm.getEquipmentSpecificId());
        List<FireFightingSystemEntity> sys = new ArrayList<>();
        String[] ids;
        String sysIds = equipmentSpecific.getSystemId();
        if (StringUtil.isNotEmpty(sysIds)) {
            if (-1 != sysIds.indexOf(",")) {
                ids = sysIds.split(",");
                sys = fireFightingSystemMapper.getFightingSysByIds(ids);
            } else {
                FireFightingSystemEntity entity = fireFightingSystemMapper.selectById(Long.valueOf(sysIds));
                sys.add(entity);
            }
        }
        map.put("equipDetail", equipmentSpecificInfo);
        map.put("videoList", videoVOS);
        map.put("proObjectList", list);
        map.put("systemList", sys);
        return map;
    }

    @Override
    public Map<String, Object> getSpecificInfoByCode(String code) {
        QueryWrapper<EquipmentSpecific> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", code);
        EquipmentSpecific equipmentSpecific = equipmentSpecificService.getOne(queryWrapper);
        if (!ObjectUtils.isEmpty(equipmentSpecific)) {
            Map<String, Object> map = new HashMap<>();
            Long id = equipmentSpecific.getId();
            Map<String, Object> equipmentSpecificInfo = equipmentSpecificMapper.getEquipSpeInfo(id);
            List<Video> videos = equipmentSpecificIndexService.getVideoByEquipmentSecificId(id);
            List<VideoVO> videoVOS = new ArrayList<>();
            videos.forEach(x -> {
                VideoVO video = new VideoVO();
                video.setName(x.getName());
                video.setTokens(x.getToken());
                video.setUrl(x.getUrl());
                video.setIp(x.getIp());
                video.setPort(x.getPort());
                video.setCode(x.getCode());
                video.setPresetPosition(x.getPresetPosition());
                videoVOS.add(video);
            });
            List<Map<String, Object>> list = this.baseMapper.getProObject(id);
            List<FireFightingSystemEntity> sys = new ArrayList<>();
            String[] ids;
            String sysIds = equipmentSpecific.getSystemId();
            if (StringUtil.isNotEmpty(sysIds)) {
                if (-1 != sysIds.indexOf(",")) {
                    ids = sysIds.split(",");
                    sys = fireFightingSystemMapper.getFightingSysByIds(ids);
                } else {
                    FireFightingSystemEntity entity = fireFightingSystemMapper.selectById(Long.valueOf(sysIds));
                    sys.add(entity);
                }
            }
            map.put("equipDetail", equipmentSpecificInfo);
            map.put("videoList", videoVOS);
            map.put("proObjectList", list);
            map.put("systemList", sys);
            return map;
        }
        return Maps.newLinkedHashMap();
    }


    @Override
    public List<HashMap<String, Object>> getColumn(String alarmType) {
        List<HashMap<String, Object>> titleList = new ArrayList<>();
        HashMap<String, Object> map = new HashMap<>();
        map.put("key", AlarmGridColumnEnum.GJLX.getKey());
        map.put("title", AlarmGridColumnEnum.GJLX.getTitle());
        map.put("dataIndex", AlarmGridColumnEnum.GJLX.getDataIndex());
        titleList.add(map);
        HashMap<String, Object> map1 = new HashMap<>();
        map1.put("key", AlarmGridColumnEnum.GJSB.getKey());
        map1.put("title", AlarmGridColumnEnum.GJSB.getTitle());
        map1.put("dataIndex", AlarmGridColumnEnum.GJSB.getDataIndex());
        titleList.add(map1);
        HashMap<String, Object> map2 = new HashMap<>();
        map2.put("key", AlarmGridColumnEnum.GJNR.getKey());
        map2.put("title", AlarmGridColumnEnum.GJNR.getTitle());
        map2.put("dataIndex", AlarmGridColumnEnum.GJNR.getDataIndex());
        titleList.add(map2);
        HashMap<String, Object> map3 = new HashMap<>();
        map3.put("key", AlarmGridColumnEnum.SBBH.getKey());
        map3.put("title", AlarmGridColumnEnum.SBBH.getTitle());
        map3.put("dataIndex", AlarmGridColumnEnum.SBBH.getDataIndex());
        titleList.add(map3);
        HashMap<String, Object> map4 = new HashMap<>();
        map4.put("key", AlarmGridColumnEnum.GJWZ.getKey());
        map4.put("title", AlarmGridColumnEnum.GJWZ.getTitle());
        map4.put("dataIndex", AlarmGridColumnEnum.GJWZ.getDataIndex());
        titleList.add(map4);
        HashMap<String, Object> map5 = new HashMap<>();
        map5.put("key", AlarmGridColumnEnum.BHDX.getKey());
        map5.put("title", AlarmGridColumnEnum.BHDX.getTitle());
        map5.put("dataIndex", AlarmGridColumnEnum.BHDX.getDataIndex());
        titleList.add(map5);
        HashMap<String, Object> map6 = new HashMap<>();
        map6.put("key", AlarmGridColumnEnum.GJSJ.getKey());
        map6.put("title", AlarmGridColumnEnum.GJSJ.getTitle());
        map6.put("dataIndex", AlarmGridColumnEnum.GJSJ.getDataIndex());
        titleList.add(map6);
        HashMap<String, Object> map7 = new HashMap<>();
        map7.put("key", AlarmGridColumnEnum.CLZT.getKey());
        map7.put("title", AlarmGridColumnEnum.CLZT.getTitle());
        map7.put("dataIndex", AlarmGridColumnEnum.CLZT.getDataIndex());
        titleList.add(map7);
        HashMap<String, Object> map8 = new HashMap<>();
        map8.put("key", AlarmGridColumnEnum.CLLX.getKey());
        map8.put("title", AlarmGridColumnEnum.CLLX.getTitle());
        map8.put("dataIndex", AlarmGridColumnEnum.CLLX.getDataIndex());
        titleList.add(map8);
        return titleList;
    }

    @Override
    public List<AlarmDataVO> getAlarmDetailById(Long id, String alarmType) {
        List<HashMap<String, Object>> list = this.baseMapper.getAlarmDetail(id, alarmType);
        List<AlarmDataVO> lists = new ArrayList<>();
        if (0 < list.size()) {
            HashMap<String, Object> alarm = list.get(0);
            AlarmDataVO alarmDataVO = new AlarmDataVO();
            alarmDataVO.setKey(AlarmGridColumnEnum.GJLX.getTitle());
            alarmDataVO.setValue(AlarmTypeEnum.HZGJ.getCode().equals(alarm.get("type")) ? AlarmTypeEnum.HZGJ.getType() : AlarmTypeEnum.GZGJ.getType());
            lists.add(alarmDataVO);
            AlarmDataVO alarmDataVO1 = new AlarmDataVO();
            alarmDataVO1.setKey(AlarmGridColumnEnum.GJNR.getTitle());
            alarmDataVO1.setValue(StringUtil.isNotEmpty(alarm.get("alamContent")) ? alarm.get("alamContent").toString() : null);
            lists.add(alarmDataVO1);
            AlarmDataVO alarmDataVO2 = new AlarmDataVO();
            alarmDataVO2.setKey(AlarmGridColumnEnum.GJWZ.getTitle());
            alarmDataVO2.setValue(StringUtil.isNotEmpty(alarm.get("warehouseStructureName")) ? alarm.get("warehouseStructureName").toString() : null);
            lists.add(alarmDataVO2);
            AlarmDataVO alarmDataVO3 = new AlarmDataVO();
            alarmDataVO3.setKey(AlarmGridColumnEnum.GJSJ.getTitle());
            String createDate = "";
            if (StringUtil.isNotEmpty(alarm.get("createDate"))) {
                createDate = alarm.get("createDate").toString();
                createDate = createDate.substring(0, createDate.length() - 2);
            }
            alarmDataVO3.setValue(StringUtil.isNotEmpty(createDate) ? createDate : null);
            lists.add(alarmDataVO3);
            AlarmDataVO alarmDataVO4 = new AlarmDataVO();
            alarmDataVO4.setKey(AlarmGridColumnEnum.GJBH.getTitle());
            alarmDataVO4.setValue(StringUtil.isNotEmpty(alarm.get("id")) ? alarm.get("type") + alarm.get("id").toString() : null);
            lists.add(alarmDataVO4);
            AlarmDataVO alarmDataVO5 = new AlarmDataVO();
            alarmDataVO5.setKey(AlarmGridColumnEnum.GJSB.getTitle());
            alarmDataVO5.setValue(StringUtil.isNotEmpty(alarm.get("fireEquipmentName")) ? alarm.get("fireEquipmentName").toString() : null);
            lists.add(alarmDataVO5);
            AlarmDataVO alarmDataVO6 = new AlarmDataVO();
            alarmDataVO6.setKey(AlarmGridColumnEnum.SBBH.getTitle());
            alarmDataVO6.setValue(StringUtil.isNotEmpty(alarm.get("fireEquipmentCode")) ? alarm.get("fireEquipmentCode").toString() : null);
            lists.add(alarmDataVO6);
            AlarmDataVO alarmDataVO7 = new AlarmDataVO();
            alarmDataVO7.setKey("equipmentSpecificId");
            alarmDataVO7.setValue(StringUtil.isNotEmpty(alarm.get("fireEquipmentId")) ? alarm.get("fireEquipmentId").toString() : null);
            lists.add(alarmDataVO7);
        }
        return lists;
    }

    @Override
    public AlarmEquipMockDataVO getEquipmentDetailById(Long id, String alarmType) {
        List<Map<String, Object>> list = this.baseMapper.getEquipmentDetails(id, alarmType);
        int count = this.baseMapper.getEquipmentAlarmCount(id, alarmType);
        AlarmEquipMockDataVO alarmEquipMockDataVO = new AlarmEquipMockDataVO();
        List<AlarmDataVO> lists = new ArrayList<>();
        if (0 < list.size()) {
            Map<String, Object> sourceData = list.get(0);
            AlarmDataVO alarmDataVO1 = new AlarmDataVO();
            alarmDataVO1.setKey(EquipmentDataEnum.MC.getName());
            alarmDataVO1.setValue(StringUtil.isNotEmpty(sourceData.get("fireEquipmentName")) ? sourceData.get("fireEquipmentName").toString() : null);
            lists.add(alarmDataVO1);
            AlarmDataVO alarmDataVO2 = new AlarmDataVO();
            alarmDataVO2.setKey(EquipmentDataEnum.PP.getName());
            alarmDataVO2.setValue(StringUtil.isNotEmpty(sourceData.get("brand")) ? sourceData.get("brand").toString() : null);
            lists.add(alarmDataVO2);
            AlarmDataVO alarmDataVO3 = new AlarmDataVO();
            alarmDataVO3.setKey(EquipmentDataEnum.XH.getName());
            alarmDataVO3.setValue(StringUtil.isNotEmpty(sourceData.get("batchNum")) ? sourceData.get("batchNum").toString() : null);
            lists.add(alarmDataVO3);
            AlarmDataVO alarmDataVO4 = new AlarmDataVO();
            alarmDataVO4.setKey(EquipmentDataEnum.WZ.getName());
            alarmDataVO4.setValue(StringUtil.isNotEmpty(sourceData.get("warehouseStructureName")) ? sourceData.get("warehouseStructureName").toString() : null);
            lists.add(alarmDataVO4);
            AlarmDataVO alarmDataVO5 = new AlarmDataVO();
            alarmDataVO5.setKey(EquipmentDataEnum.XT.getName());
            alarmDataVO5.setValue(StringUtil.isNotEmpty(sourceData.get("systemName")) ? sourceData.get("systemName").toString() : null);
            lists.add(alarmDataVO5);
            alarmEquipMockDataVO.setPic(StringUtil.isNotEmpty(sourceData.get("imgUrl")) ? sourceData.get("imgUrl").toString() : null);
            alarmEquipMockDataVO.setAlarmCount(count);
            alarmEquipMockDataVO.setQrcode(StringUtil.isNotEmpty(sourceData.get("qrCode")) ? sourceData.get("qrCode").toString() : null);
            alarmEquipMockDataVO.setDetailUrl(null);
            alarmEquipMockDataVO.setItems(lists);
        }
        return alarmEquipMockDataVO;
    }

    @Override
    public Map<String, Object> detail(Long id) {
        QueryWrapper<EquipmentSpecificAlarm> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("id", id);
        EquipmentSpecificAlarm specificAlarm = this.baseMapper.selectOne(queryWrapper);
        String alarmType = specificAlarm.getType();
        List<AlarmDataVO> list = getAlarmDetailById(id, alarmType);
        Long equipId = null;
        Map<String, Object> map = new HashMap<>();
        Map<String, Object> map1 = new HashMap<>();
        AlarmEquipMockDataVO alarmEquipMockDataVO = new AlarmEquipMockDataVO();
        if (0 < list.size()) {
            for (AlarmDataVO alarm : list) {
                if ("equipmentSpecificId".equals(alarm.getKey())) {
                    equipId = Long.parseLong(alarm.getValue());
                    break;
                }
            }
            alarmEquipMockDataVO = getEquipmentDetailById(equipId, alarmType);
        }
        if (0 < list.size()) {
            for (int i = list.size() - 1; i >= 0; i--) {
                if ("equipmentSpecificId".equals(list.get(i).getKey())) {
                    list.remove(i);
                }
            }
        }
        map1.put("baseInfo", list);
        map1.put("processInfo", getProcessInfo(id));
        map.put("alarmData", map1);
        map.put("equipmentData", alarmEquipMockDataVO);
        return map;
    }

    @Override
    public List<FireEquipmentFireAlarm> getFireEquipAlarmDetailsByAlarmId(List<Long> specificAlarmIds, List<Long> equipIndexIds) {
        List<FireEquipmentFireAlarm> list = this.baseMapper.getFireEquipAlarmDetailsByAlarmId(specificAlarmIds, equipIndexIds);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        return Lists.newArrayList();
    }

    private List<AlarmDataVO> getProcessInfo(Long id) {
        EquipmentSpecificAlarmLog alam = confirmAlarmMapper.getDetailsById(id, null);

        List<AlarmDataVO> lists = new ArrayList<>();
        AlarmDataVO v1 = new AlarmDataVO();
        v1.setKey("确认类型");
        v1.setValue(ConfirmAlamEnum.getTypeByCode(alam.getConfirmType()));
        lists.add(v1);

        AlarmDataVO v2 = new AlarmDataVO();
        v2.setKey("报警原因");
        v2.setValue(alam.getAlarmReason());
        lists.add(v2);

        AlarmDataVO v3 = new AlarmDataVO();
        v3.setKey("处理措施");
        v3.setValue(alam.getResolveResult());
        lists.add(v3);

        AlarmDataVO v4 = new AlarmDataVO();
        v4.setKey("处理时间");
        v4.setValue(StringUtil.isNotEmpty(alam.getConfirmDate()) ? new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(alam.getConfirmDate()) : null);
        lists.add(v4);

        AlarmDataVO v5 = new AlarmDataVO();
        v5.setKey("处理人");
        v5.setValue(alam.getConfirmUserName());
        lists.add(v5);

        return lists;
    }

    private static String getInet4Address() {
        Enumeration<NetworkInterface> nis;
        String ip = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
            for (; nis.hasMoreElements(); ) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                for (; ias.hasMoreElements(); ) {
                    InetAddress ia = ias.nextElement();
                    if (ia instanceof Inet4Address && !ia.getHostAddress().equals("127.0.0.1")) {
                        ip = ia.getHostAddress();
                    }
                }
            }
        } catch (SocketException e) {
            e.printStackTrace();
        }
        return ip;
    }

    @Override
    public int getCountAlarmEquipment() {
        return equipmentSpecificAlarmMapper.getCountAlarmEquipment();
    }

    @Override
    public int getCountEquipment() {
        return equipmentSpecificAlarmMapper.getCountEquipment();
    }

    @Override
    public List<Map<String, Object>> getCountAlarm() {
        return equipmentSpecificAlarmMapper.getCountAlarm();
    }

    @Override
    public Page<EquipSpecificAlarmDTO> getAlarmPage(Page page, AlarmDTO dto) {
        return equipmentSpecificAlarmMapper.getAlarmPage(page, dto);
    }

    @Override
    public Page<EquipSpecificAlarmDTO> getEqPage(Page page, AlarmDTO dto) {
        return equipmentSpecificAlarmMapper.getEqPage(page, dto);
    }

    @Override
    public Integer getcountAlarmtype(String tyep) {
        return equipmentSpecificAlarmMapper.getcountAlarmtype(tyep);
    }

    @Override
    public Integer getcountAlarmHandle(String tyep) {
        return equipmentSpecificAlarmMapper.getcountAlarmHandle(tyep);
    }

    @Override
    public List<EquipmentSpecificAlarm> getEquipListBySpecific(Boolean status,
                                                               Long equipmentSpecificId) {
        return equipmentSpecificAlarmMapper.getEquipListBySpecific(status, equipmentSpecificId);
    }

}
