package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

/**
 * 安全追溯-电梯
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("3000")
public class ElevatorTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "ratedSpeedUp", label = "额定速度(上行)", type = TechnicalParameter.ParamType.STRING)
    private String ratedSpeedUp;


    @TechnicalParameter(key = "ratedSpeedDown", label = "额定速度(下行)", type = TechnicalParameter.ParamType.STRING)
    private String ratedSpeedDown;


    @TechnicalParameter(key = "ratedLoadCapacity", label = "额定载重量", type = TechnicalParameter.ParamType.STRING)
    private String ratedLoadCapacity;


    @TechnicalParameter(key = "liftingHeight", label = "提升高度", type = TechnicalParameter.ParamType.STRING)
    private String liftingHeight;


    @TechnicalParameter(key = "deviceLevel", label = "层数", type = TechnicalParameter.ParamType.INTEGER)
    private Integer deviceLevel;


    @TechnicalParameter(key = "stand", label = "站数", type = TechnicalParameter.ParamType.INTEGER)
    private Integer stand;


    @TechnicalParameter(key = "numberDoors", label = "门数", type = TechnicalParameter.ParamType.STRING)
    private Integer numberDoors;


    @TechnicalParameter(key = "controlMode", label = "控制方式", type = TechnicalParameter.ParamType.STRING, dictCode = "DSXS")
    private String controlMode;


    @TechnicalParameter(key = "numberCylinders", label = "油缸数量", type = TechnicalParameter.ParamType.STRING)
    private Integer numberCylinders;


    @TechnicalParameter(key = "jackingType", label = "顶升方式", type = TechnicalParameter.ParamType.STRING, dictCode = "DSXS")
    private String jackingType;


    @TechnicalParameter(key = "explosionproofGrade", label = "区域防爆等级", type = TechnicalParameter.ParamType.STRING, dictCode = "FBDJ")
    private String explosionproofGrade;


    @TechnicalParameter(key = "explosionproofSignComplete", label = "整机防爆标志", type = TechnicalParameter.ParamType.STRING)
    private String explosionproofSignComplete;


    @TechnicalParameter(key = "nominalSpeed", label = "名义速度", type = TechnicalParameter.ParamType.STRING)
    private String nominalSpeed;


    @TechnicalParameter(key = "nominalWidth", label = "名义宽度", type = TechnicalParameter.ParamType.STRING)
    private String nominalWidth;

    @TechnicalParameter(key = "angleRoll", label = "倾斜角", type = TechnicalParameter.ParamType.STRING)
    private String angleRoll;


    @TechnicalParameter(key = "useSectionLength", label = "使用区段长度", type = TechnicalParameter.ParamType.STRING)
    private String useSectionLength;


    @TechnicalParameter(key = "conveyingCapacity", label = "输送能力", type = TechnicalParameter.ParamType.STRING)
    private String conveyingCapacity;


    @TechnicalParameter(key = "doorPosition", label = "轿门位置", type = TechnicalParameter.ParamType.STRING)
    private String doorPosition;


    @TechnicalParameter(key = "ratedSpeed", label = "额定速度", type = TechnicalParameter.ParamType.STRING)
    private String ratedSpeed;
}
