package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

/**
 * 安全追溯-起重机械
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("4000")
public class LiftingTechParamDefine implements ITechParamDefine {

    @TechnicalParameter(key = "ratedLiftingCapacity", label = "额定起重量", type = TechnicalParameter.ParamType.STRING)
    private String ratedLiftingCapacity;


    @TechnicalParameter(key = "maxLiftingCapacity", label = "最大起重量", type = TechnicalParameter.ParamType.STRING)
    private String maxLiftingCapacity;


    @TechnicalParameter(key = "maxLiftingTorque", label = "最大起重力矩", type = TechnicalParameter.ParamType.STRING)
    private String maxLiftingTorque;


    @TechnicalParameter(key = "spanWorkingRange", label = "跨度（工作幅度）", type = TechnicalParameter.ParamType.STRING)
    private String spanWorkingRange;


    @TechnicalParameter(key = "liftingSpeed", label = "起升速度", type = TechnicalParameter.ParamType.STRING)
    private String liftingSpeed;


    @TechnicalParameter(key = "liftingHeight", label = "起升高度", type = TechnicalParameter.ParamType.STRING)
    private String liftingHeight;


    @TechnicalParameter(key = "workLevel", label = "工作级别", type = TechnicalParameter.ParamType.STRING, dictCode = "GZJB")
    private String workLevel;


    @TechnicalParameter(key = "ratedLiftingTorque", label = "额定起重力矩", type = TechnicalParameter.ParamType.STRING)
    private String ratedLiftingTorque;


    @TechnicalParameter(key = "numberStorey", label = "层数/泊位数", type = TechnicalParameter.ParamType.STRING)
    private Integer numberStorey;


    @TechnicalParameter(key = "runningSpeed", label = "运行速度", type = TechnicalParameter.ParamType.STRING)
    private String runningSpeed;


    @TechnicalParameter(key = "bigcarRunSpeed", label = "大车运行速度", type = TechnicalParameter.ParamType.STRING)
    private String bigcarRunSpeed;


    @TechnicalParameter(key = "smallcarrunSpeed", label = "小车运行速度", type = TechnicalParameter.ParamType.STRING)
    private String smallcarrunSpeed;


    @TechnicalParameter(key = "ratedMembers", label = "额定成员数", type = TechnicalParameter.ParamType.STRING)
    private Integer ratedMembers;


    @TechnicalParameter(key = "ratedLiftingSpeed", label = "额定提升速度", type = TechnicalParameter.ParamType.STRING)
    private String ratedLiftingSpeed;


    @TechnicalParameter(key = "heightFreeEnd", label = "自由端高度", type = TechnicalParameter.ParamType.STRING)
    private String heightFreeEnd;


    @TechnicalParameter(key = "workStrokeCage", label = "吊笼工作行程", type = TechnicalParameter.ParamType.STRING)
    private String workStrokeCage;


    @TechnicalParameter(key = "storageCapacity", label = "存容量", type = TechnicalParameter.ParamType.INTEGER)
    private Integer storageCapacity;


    @TechnicalParameter(key = "ratedLiftSpeed", label = "额定升降速度", type = TechnicalParameter.ParamType.STRING)
    private String ratedLiftSpeed;


    @TechnicalParameter(key = "ratedTraverseSpeed", label = "额定横移速度", type = TechnicalParameter.ParamType.STRING)
    private String ratedTraverseSpeed;


    @TechnicalParameter(key = "bicycleMaxExitTime", label = "单车最大进(出)车时间", type = TechnicalParameter.ParamType.STRING)
    private String bicycleMaxExitTime;


    @TechnicalParameter(key = "bicycleMaxComeTime", label = "单车最大进车时间", type = TechnicalParameter.ParamType.STRING)
    private String bicycleMaxComeTime;


    @TechnicalParameter(key = "explosionProofGrade", label = "区域防爆等级", type = TechnicalParameter.ParamType.STRING, dictCode = "FBDJ")
    private String explosionProofGrade;


    @TechnicalParameter(key = "cantileverLength", label = "悬臂长度", type = TechnicalParameter.ParamType.STRING)
    private String cantileverLength;

    @TechnicalParameter(key = "derrickingSpeed", label = "变幅速度", type = TechnicalParameter.ParamType.STRING)
    private String derrickingSpeed;


    @TechnicalParameter(key = "hangingCagesNumber", label = "吊笼数量", type = TechnicalParameter.ParamType.STRING)
    private String hangingCagesNumber;


    @TechnicalParameter(key = "explosiveSubstance", label = "燃爆物质", type = TechnicalParameter.ParamType.STRING)
    private String explosiveSubstance;


    @TechnicalParameter(key = "explosionproofSignComplete", label = "整机防爆标志", type = TechnicalParameter.ParamType.STRING)
    private String explosionproofSignComplete;


    @TechnicalParameter(key = "ratedSpeedUp", label = "监检结束高度", type = TechnicalParameter.ParamType.STRING)
    private String ratedSpeedUp;


    @TechnicalParameter(key = "parkingVehicleHeight", label = "适停车辆尺寸高", type = TechnicalParameter.ParamType.STRING)
    private String parkingVehicleHeight;


    @TechnicalParameter(key = "parkingVehicleWeight", label = "适停车辆尺寸宽", type = TechnicalParameter.ParamType.STRING)
    private String parkingVehicleWeight;


    @TechnicalParameter(key = "parkingVehicleLength", label = "适停车辆尺寸长", type = TechnicalParameter.ParamType.STRING)
    private String parkingVehicleLength;

}
