package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

/**
 * 安全追溯-游乐设施
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("6000")
public class RidesTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "trackHeight", label = "轨道高度", type = TechnicalParameter.ParamType.STRING)
    private String trackHeight;


    @TechnicalParameter(key = "runningSpeed", label = "运行速度", type = TechnicalParameter.ParamType.STRING)
    private String runningSpeed;


    @TechnicalParameter(key = "numberOfPassengers", label = "乘坐人数", type = TechnicalParameter.ParamType.STRING)
    private Integer numberOfPassengers;


    @TechnicalParameter(key = "slideLength", label = "滑道长度", type = TechnicalParameter.ParamType.STRING)
    private String slideLength;


    @TechnicalParameter(key = "operatingHeight", label = "运行高度", type = TechnicalParameter.ParamType.STRING)
    private String operatingHeight;


    @TechnicalParameter(key = "slideHeight", label = "蹦极绳长度", type = TechnicalParameter.ParamType.STRING)
    private String slideHeight;


    @TechnicalParameter(key = "rotaryDiameter", label = "回转直径", type = TechnicalParameter.ParamType.STRING)
    private String rotaryDiameter;


    @TechnicalParameter(key = "unilateralSwingAngle", label = "单边摆角", type = TechnicalParameter.ParamType.STRING)
    private String unilateralSwingAngle;


    @TechnicalParameter(key = "numberOfVehicles", label = "车辆数", type = TechnicalParameter.ParamType.INTEGER)
    private Integer numberOfVehicles;


    @TechnicalParameter(key = "dip", label = "倾角", type = TechnicalParameter.ParamType.STRING)
    private String dip;


    @TechnicalParameter(key = "equipmentHeight", label = "设备高度", type = TechnicalParameter.ParamType.STRING)
    private String equipmentHeight;

}
