package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

/**
 * 安全追溯-索道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("9000")
public class RopewayTechParamDefine implements ITechParamDefine {

    @TechnicalParameter(key = "horizontalDistance", label = "平距", type = TechnicalParameter.ParamType.STRING)
    private String horizontalDistance;


    @TechnicalParameter(key = "supportsCount", label = "支架数目", type = TechnicalParameter.ParamType.INTEGER)
    private Integer supportsCount;


    @TechnicalParameter(key = "obliqueLength", label = "斜长", type = TechnicalParameter.ParamType.STRING)
    private String obliqueLength;


    @TechnicalParameter(key = "mainMotorModel", label = "主电机型式", type = TechnicalParameter.ParamType.STRING)
    private String mainMotorModel;


    @TechnicalParameter(key = "mainMotorPower", label = "主电机功率", type = TechnicalParameter.ParamType.STRING)
    private String mainMotorPower;


    @TechnicalParameter(key = "altitudeDifference", label = "高差", type = TechnicalParameter.ParamType.STRING)
    private String altitudeDifference;


    @TechnicalParameter(key = "freightVolume", label = "运量", type = TechnicalParameter.ParamType.STRING)
    private String freightVolume;

    @TechnicalParameter(key = "carrierLine", label = "运载索", type = TechnicalParameter.ParamType.STRING, dictCode = "YZS")
    private String carrierLine;


    @TechnicalParameter(key = "speed", label = "速度", type = TechnicalParameter.ParamType.STRING)
    private String speed;

    @TechnicalParameter(key = "bearingCable", label = "承载索", type = TechnicalParameter.ParamType.STRING)
    private String bearingCable;


    @TechnicalParameter(key = "cablePitch", label = "索距", type = TechnicalParameter.ParamType.STRING)
    private String cablePitch;


    @TechnicalParameter(key = "oilPressureHeavyHammer", label = "张紧油压（重锤重量）", type = TechnicalParameter.ParamType.STRING)
    private String oilPressureHeavyHammer;


    @TechnicalParameter(key = "numberAndTypeOfVehicles", label = "运载工具数量和类型", type = TechnicalParameter.ParamType.STRING)
    private String numberAndTypeOfVehicles;

}
