package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

/**
 * 安全追溯-场内车辆
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("5000")
public class VehicleTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "frameNo", label = "车架编号", type = TechnicalParameter.ParamType.STRING)
    private String frameNo;


    @TechnicalParameter(key = "engineNo", label = "发动机（行走电机）编号", type = TechnicalParameter.ParamType.STRING)
    private String engineNo;


    @TechnicalParameter(key = "liftingCapacity", label = "额定起重量", type = TechnicalParameter.ParamType.STRING)
    private String liftingCapacity;


    @TechnicalParameter(key = "transmissionMode", label = "传动方式", type = TechnicalParameter.ParamType.STRING)
    private String transmissionMode;


    @TechnicalParameter(key = "weight", label = "自重", type = TechnicalParameter.ParamType.STRING)
    private String weight;

    @TechnicalParameter(key = "powerMode", label = "动力方式", type = TechnicalParameter.ParamType.STRING)
    private String powerMode;


    @TechnicalParameter(key = "maxRunningSpeed", label = "最大运行速度", type = TechnicalParameter.ParamType.STRING)
    private String maxRunningSpeed;


    @TechnicalParameter(key = "maxLiftingHeight", label = "工作装置空载最大起升高度", type = TechnicalParameter.ParamType.STRING)
    private String maxLiftingHeight;


    @TechnicalParameter(key = "gasGroup", label = "气体/粉尘组别（防爆）", type = TechnicalParameter.ParamType.STRING)
    private String gasGroup;


    @TechnicalParameter(key = "frameStructure", label = "车架结构", type = TechnicalParameter.ParamType.STRING)
    private String frameStructure;


    @TechnicalParameter(key = "drivingMode", label = "驾驶方式", type = TechnicalParameter.ParamType.STRING)
    private String drivingMode;


    @TechnicalParameter(key = "carryingIdlerMaxRunningSpeed", label = "空载最大运行速度", type = TechnicalParameter.ParamType.STRING)
    private String carryingIdlerMaxRunningSpeed;


    @TechnicalParameter(key = "protectGrade", label = "设备保护等级（防爆）", type = TechnicalParameter.ParamType.STRING, dictCode = "FBDJ")
    private String protectGrade;


    @TechnicalParameter(key = "temperatureGroup", label = "温度组别（防爆）", type = TechnicalParameter.ParamType.STRING)
    private String temperatureGroup;


    @TechnicalParameter(key = "passengersNumber", label = "额定载客人数", type = TechnicalParameter.ParamType.INTEGER)
    private Integer passengersNumber;


    @TechnicalParameter(key = "maxDrivingSlope", label = "最大行驶坡度", type = TechnicalParameter.ParamType.STRING)
    private String maxDrivingSlope;


    @TechnicalParameter(key = "vehicleMass", label = "整车整备质量", type = TechnicalParameter.ParamType.STRING)
    private String vehicleMass;


    @TechnicalParameter(key = "wheelBase", label = "轴距", type = TechnicalParameter.ParamType.STRING)
    private String wheelBase;


    @TechnicalParameter(key = "trackWidthFront", label = "轮距（前）", type = TechnicalParameter.ParamType.STRING)
    private String trackWidthFront;


    @TechnicalParameter(key = "trackWidthBehind", label = "轮距（后）", type = TechnicalParameter.ParamType.STRING)
    private String trackWidthBehind;


    @TechnicalParameter(key = "carsNumber", label = "观光列车车厢数", type = TechnicalParameter.ParamType.INTEGER)
    private Integer carsNumber;


    @TechnicalParameter(key = "seatNumber", label = "观光列车每节车厢座位数", type = TechnicalParameter.ParamType.INTEGER)
    private Integer seatNumber;


    @TechnicalParameter(key = "tractorSeatNumber", label = "观光列车牵引车头座位数", type = TechnicalParameter.ParamType.INTEGER)
    private Integer tractorSeatNumber;


    @TechnicalParameter(key = "maxLiftingSpeed", label = "空载最大起升速度", type = TechnicalParameter.ParamType.STRING)
    private String maxLiftingSpeed;

}
