package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

/**
 * 安全追溯-压力容器
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("2000")
public class VesselTechParamsDefine implements ITechParamDefine {

    @TechnicalParameter(key = "ratedQuality", label = "额定质量", type = TechnicalParameter.ParamType.STRING)
    private String ratedQuality;

    @TechnicalParameter(key = "ambientTemperature", label = "使用环境温度", type = TechnicalParameter.ParamType.STRING)
    private String ambientTemperature;

    @TechnicalParameter(key = "modelNumber", label = "型号", type = TechnicalParameter.ParamType.STRING)
    private String modelNumber;

    @TechnicalParameter(key = "num", label = "数量", type = TechnicalParameter.ParamType.STRING)
    private Integer num;

    @TechnicalParameter(key = "singleBottleVolume", label = "单瓶容积", type = TechnicalParameter.ParamType.STRING)
    private String singleBottleVolume;

    @TechnicalParameter(key = "totalVolume", label = "总容积", type = TechnicalParameter.ParamType.STRING)
    private String totalVolume;

    @TechnicalParameter(key = "chargingMedium", label = "充装介质", type = TechnicalParameter.ParamType.STRING)
    private String chargingMedium;

    @TechnicalParameter(key = "specification", label = "规格", type = TechnicalParameter.ParamType.STRING)
    private String specification;

    @TechnicalParameter(key = "outsideDiameter", label = "外径", type = TechnicalParameter.ParamType.STRING)
    private String outsideDiameter;

    @TechnicalParameter(key = "wallThickness", label = "壁厚", type = TechnicalParameter.ParamType.STRING)
    private String wallThickness;

    @TechnicalParameter(key = "length", label = "长度", type = TechnicalParameter.ParamType.STRING)
    private String length;

    @TechnicalParameter(key = "nominalWorkingPressure", label = "公称工作压力", type = TechnicalParameter.ParamType.STRING)
    private String nominalWorkingPressure;

    @TechnicalParameter(key = "bottleBody", label = "材料（瓶体）", type = TechnicalParameter.ParamType.STRING)
    private String bottleBody;

    @TechnicalParameter(key = "endPlug", label = "材料（端塞）", type = TechnicalParameter.ParamType.STRING)
    private String endPlug;

    @TechnicalParameter(key = "piping", label = "材料（管路）", type = TechnicalParameter.ParamType.STRING)
    private String piping;

    @TechnicalParameter(key = "qpLossless", label = "无损检测方法（气瓶）", type = TechnicalParameter.ParamType.STRING)
    private String qpLossless;

    @TechnicalParameter(key = "glLossless", label = "无损检测方法（管路）", type = TechnicalParameter.ParamType.STRING)
    private String glLossless;

    @TechnicalParameter(key = "qpRatio", label = "无损检测比例（气瓶）", type = TechnicalParameter.ParamType.STRING)
    private String qpRatio;


    @TechnicalParameter(key = "glRatio", label = "无损检测比例（管路）", type = TechnicalParameter.ParamType.STRING)
    private String glRatio;

    @TechnicalParameter(key = "qpPressure", label = "耐压试验压力（气瓶）", type = TechnicalParameter.ParamType.STRING)
    private String qpPressure;

    @TechnicalParameter(key = "glPressure", label = "耐压试验压力（管路）", type = TechnicalParameter.ParamType.STRING)
    private String glPressure;

    @TechnicalParameter(key = "qpAirTightness", label = "气密性试验压力（气瓶）", type = TechnicalParameter.ParamType.STRING)
    private String qpAirTightness;

    @TechnicalParameter(key = "glAirTightness", label = "气密性试验压力（管路）", type = TechnicalParameter.ParamType.STRING)
    private String glAirTightness;

    @TechnicalParameter(key = "displacementPressure", label = "气体置换后压力", type = TechnicalParameter.ParamType.STRING)
    private String displacementPressure;

    @TechnicalParameter(key = "oxygen", label = "瓶体内含氧量", type = TechnicalParameter.ParamType.STRING)
    private String oxygen;

    @TechnicalParameter(key = "heatTreatmentMethod", label = "瓶体内含氧量", type = TechnicalParameter.ParamType.STRING)
    private String heatTreatmentMethod;

    @TechnicalParameter(key = "qpHeatTreatmentTemperature", label = "热处理温度", type = TechnicalParameter.ParamType.STRING)
    private String qpHeatTreatmentTemperature;

    @TechnicalParameter(key = "installationPosition", label = "气瓶安装位置", type = TechnicalParameter.ParamType.STRING)
    private String installationPosition;

    @TechnicalParameter(key = "containerVolume", label = "容器容积", type = TechnicalParameter.ParamType.STRING)
    private String containerVolume;

    @TechnicalParameter(key = "pressureVesselDiameter", label = "容器内径", type = TechnicalParameter.ParamType.STRING)
    private String pressureVesselDiameter;

    @TechnicalParameter(key = "height", label = "容器高(长)", type = TechnicalParameter.ParamType.STRING)
    private String height;

    @TechnicalParameter(key = "materialCylinderShell", label = "材料（筒体(球壳)）", type = TechnicalParameter.ParamType.STRING)
    private String materialCylinderShell;

    @TechnicalParameter(key = "pressureMaterialHead", label = "材料（封头）", type = TechnicalParameter.ParamType.STRING)
    private String pressureMaterialHead;

    @TechnicalParameter(key = "pressureMaterialLining", label = "材料（衬里）", type = TechnicalParameter.ParamType.STRING)
    private String pressureMaterialLining;

    @TechnicalParameter(key = "materialJacket", label = "材料（夹套）", type = TechnicalParameter.ParamType.STRING)
    private String materialJacket;

    @TechnicalParameter(key = "thickness", label = "厚度（筒体(球壳)）", type = TechnicalParameter.ParamType.STRING)
    private String thickness;

    @TechnicalParameter(key = "fixedHead", label = "厚度（封头）", type = TechnicalParameter.ParamType.STRING)
    private String fixedHead;

    @TechnicalParameter(key = "fixedLining", label = "厚度（衬里）", type = TechnicalParameter.ParamType.STRING)
    private String fixedLining;

    @TechnicalParameter(key = "fixedJacket", label = "厚度（夹套）", type = TechnicalParameter.ParamType.STRING)
    private String fixedJacket;

    @TechnicalParameter(key = "selfWeight", label = "容器自重", type = TechnicalParameter.ParamType.STRING)
    private String selfWeight;

    @TechnicalParameter(key = "mediumWeight", label = "盛装介质重量", type = TechnicalParameter.ParamType.STRING)
    private String mediumWeight;

    @TechnicalParameter(key = "pressureHousingPath", label = "设计压力（壳程）", type = TechnicalParameter.ParamType.STRING)
    private String pressureHousingPath;

    @TechnicalParameter(key = "pressurePipe", label = "设计压力（管程）", type = TechnicalParameter.ParamType.STRING)
    private String pressurePipe;

    @TechnicalParameter(key = "pressureJacket", label = "设计压力（夹套）", type = TechnicalParameter.ParamType.STRING)
    private String pressureJacket;

    @TechnicalParameter(key = "temperatureShell", label = "设计温度（壳程）", type = TechnicalParameter.ParamType.STRING)
    private String temperatureShell;

    @TechnicalParameter(key = "temperaturePipe", label = "设计温度（管程）", type = TechnicalParameter.ParamType.STRING)
    private String temperaturePipe;

    @TechnicalParameter(key = "temperatureJacket", label = "设计温度（夹套）", type = TechnicalParameter.ParamType.STRING)
    private String temperatureJacket;

    @TechnicalParameter(key = "maxPressureShell", label = "最高允许工作压力（壳程）", type = TechnicalParameter.ParamType.STRING)
    private String maxPressureShell;

    @TechnicalParameter(key = "maxPressurePipe", label = "最高允许工作压力（管程）", type = TechnicalParameter.ParamType.STRING)
    private String maxPressurePipe;


    @TechnicalParameter(key = "maxPressureJacket", label = "最高允许工作压力（夹套）", type = TechnicalParameter.ParamType.STRING)
    private String maxPressureJacket;

    @TechnicalParameter(key = "mediumShell", label = "介质（壳程）", type = TechnicalParameter.ParamType.STRING)
    private String mediumShell;


    @TechnicalParameter(key = "mediumPipe", label = "介质（管程）", type = TechnicalParameter.ParamType.STRING)
    private String mediumPipe;


    @TechnicalParameter(key = "mediumJacket", label = "介质（夹套）", type = TechnicalParameter.ParamType.STRING)
    private String mediumJacket;


    @TechnicalParameter(key = "mainStructureType", label = "主体结构型式", type = TechnicalParameter.ParamType.STRING, dictCode = "RQJG")
    private String mainStructureType;


    @TechnicalParameter(key = "support", label = "支座型式", type = TechnicalParameter.ParamType.STRING)
    private String support;


    @TechnicalParameter(key = "installation", label = "安装型式", type = TechnicalParameter.ParamType.STRING)
    private String installation;


    @TechnicalParameter(key = "insulation", label = "保温绝热方式", type = TechnicalParameter.ParamType.STRING)
    private String insulation;


    @TechnicalParameter(key = "checkLossless", label = "无损检测方法", type = TechnicalParameter.ParamType.STRING , dictCode = "RQJCFF")
    private String checkLossless;


    @TechnicalParameter(key = "withstandVoltage", label = "耐压试验种类", type = TechnicalParameter.ParamType.STRING)
    private String withstandVoltage;


    @TechnicalParameter(key = "leakage", label = "泄漏试验种类", type = TechnicalParameter.ParamType.STRING)
    private String leakage;


    @TechnicalParameter(key = "withstandPressureTest", label = "泄漏试验压力", type = TechnicalParameter.ParamType.STRING)
    private String withstandPressureTest;


    @TechnicalParameter(key = "leakPressure", label = "泄漏试验压力", type = TechnicalParameter.ParamType.STRING)
    private String leakPressure;


    @TechnicalParameter(key = "container", label = "罐车编号", type = TechnicalParameter.ParamType.STRING)
    private String container;


    @TechnicalParameter(key = "carNum", label = "罐车编号", type = TechnicalParameter.ParamType.STRING)
    private String carNum;


    @TechnicalParameter(key = "volume", label = "容积", type = TechnicalParameter.ParamType.STRING)
    private String volume;


    @TechnicalParameter(key = "maxFill", label = "最大充装量", type = TechnicalParameter.ParamType.STRING)
    private String maxFill;


    @TechnicalParameter(key = "designPressure", label = "设计压力", type = TechnicalParameter.ParamType.STRING)
    private String designPressure;


    @TechnicalParameter(key = "designTemperature", label = "设计温度", type = TechnicalParameter.ParamType.STRING)
    private String designTemperature;


    @TechnicalParameter(key = "workingPressure", label = "工作压力", type = TechnicalParameter.ParamType.STRING)
    private String workingPressure;


    @TechnicalParameter(key = "workTemperature", label = "工作温度", type = TechnicalParameter.ParamType.STRING)
    private String workTemperature;


    @TechnicalParameter(key = "materialCylinder", label = "材料（筒体）", type = TechnicalParameter.ParamType.STRING)
    private String materialCylinder;


    @TechnicalParameter(key = "thicknessCylinder", label = "厚度（筒体）", type = TechnicalParameter.ParamType.STRING)
    private String thicknessCylinder;


    @TechnicalParameter(key = "corrosionMargin", label = "腐蚀裕量", type = TechnicalParameter.ParamType.STRING)
    private String corrosionMargin;


    @TechnicalParameter(key = "medium", label = "介质", type = TechnicalParameter.ParamType.STRING)
    private String medium;


    @TechnicalParameter(key = "oxygenChamber", label = "氧舱品种", type = TechnicalParameter.ParamType.STRING)
    private String oxygenChamber;


    @TechnicalParameter(key = "ratedEntryCapacity", label = "额定进舱人数", type = TechnicalParameter.ParamType.STRING)
    private Integer ratedEntryCapacity;


    @TechnicalParameter(key = "chamberMain", label = "主体结构", type = TechnicalParameter.ParamType.STRING)
    private String chamberMain;


    @TechnicalParameter(key = "chamberPressure", label = "压力", type = TechnicalParameter.ParamType.STRING)
    private String chamberPressure;


    @TechnicalParameter(key = "temperature", label = "温度", type = TechnicalParameter.ParamType.STRING)
    private String temperature;


    @TechnicalParameter(key = "pressureMedium", label = "压力介质", type = TechnicalParameter.ParamType.STRING)
    private String pressureMedium;


    @TechnicalParameter(key = "perCapitaCabinCapacity", label = "人均舱容", type = TechnicalParameter.ParamType.STRING)
    private String perCapitaCabinCapacity;


    @TechnicalParameter(key = "vin", label = "车辆VIN码", type = TechnicalParameter.ParamType.STRING)
    private String vin;

}
