package com.yeejoin.amos.boot.module.common.api.entity;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.time.LocalDate;
import java.util.List;

/**
 * 企业
 */
@Data
@Document(indexName = "idx_biz_enterprise_info")
public class EsBaseEnterpriseInfo {
    @Id
    private String sequenceNbr;

    /**
     * 企业code
     */
    @Field(type = FieldType.Keyword)
    private String useUnitCode;

    /**
     * 企业名称
     */
    @Field(type = FieldType.Text)
    private String useUnit;

    /**
     * 企业code,个人的包含6600_
     */
    @Field(type = FieldType.Keyword)
    private String useCode;


    /**
     * 单位地址行政区划
     */
    @Field(type = FieldType.Keyword)
    private String regionCode;

    /**
     * 监管系统唯一编码
     */
    @Field(type = FieldType.Keyword)
    private String superviseCode;

    /**
     * 联系人
     */
    @Field(type = FieldType.Keyword)
    private String contactUser;

    /**
     * 联系人电话
     */
    @Field(type = FieldType.Text)
    private String contactPhone;

    /**
     * 企业详情地址
     */
    @Field(type = FieldType.Text)
    private String address;

    /**
     * 单位类型
     */
    @Field(type = FieldType.Keyword)
    private String unitType;

    /**
     * 管辖机构OrgCode
     */
    @Field(type = FieldType.Keyword)
    private String superviseOrgCode;

    /**
     * 管辖机构名称
     */
    @Field(type = FieldType.Text)
    private String superviseOrgName;

    /**
     * 监管标签
     */
    @Field(type = FieldType.Keyword)
    private String regulatoryLabels;

    /**
     * 行业主管部门
     */
    @Field(type = FieldType.Keyword)
    private String industrySupervisor;

    /**
     * 经营状态
     */
    @Field(type = FieldType.Keyword)
    private String operatingStatus;


    /**
     * 涉及设备类型
     */
    @Field(type = FieldType.Keyword)
    private String equipCategory;


    /**
     * 公司的orgCode
     */
    @Field(type = FieldType.Keyword)
    private String orgCode;

    /**
     * 办公区域
     */
    @Field(type = FieldType.Keyword)
    private String officeRegion;


    /**
     * 企业下资质
     */
    @Field(type = FieldType.Nested)
    private List<License> licenses;

    @Data
    public static class License {

        /**
         * 资质表主键
         */
        @Field(type = FieldType.Long)
        private Long sequenceNbr;


        @Field(type = FieldType.Long)
        private Long unitLicenceId;


        /**
         * 证书类型名称
         */
        @Field(type = FieldType.Text)
        private String certType;

        /**
         * 证书类型CODE
         */
        @Field(type = FieldType.Keyword)
        private String certTypeCode;

        /**
         * 证书编号
         */
        @Field(type = FieldType.Keyword)
        private String certNo;

        /**
         * 许可到期日期
         */
        @Field(type = FieldType.Date, format = DateFormat.date)
        private LocalDate expiryDate;

        /**
         * 许可项目/检验类型/设备品种（核准项目名称）
         */
        @Field(type = FieldType.Keyword)
        private String itemCode;

        /**
         * 许可子项目/检验项目/充装介质类别code
         */
        @Field(type = FieldType.Keyword)
        private String subItemCode;

        /**
         * 机构类别枚举
         */
        @Field(type = FieldType.Keyword)
        private String agencyType;

        /**
         * 资质类型编码（检验检测、其他）
         */
        @Field(type = FieldType.Keyword)
        private String licenceType;

        /**
         * 发证机关
         */
        @Field(type = FieldType.Keyword)
        private String approvedOrganCode;

        /**
         * 发证日期
         */
        @Field(type = FieldType.Date, format = DateFormat.date)
        private LocalDate issueDate;
    }
}
