package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationReformDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationReform;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.ChangeRegistrationReformVo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 改造变更登记 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-20
 */
public interface JgChangeRegistrationReformMapper extends BaseMapper<JgChangeRegistrationReform> {
    Page<Map<String, Object>> getListPage(@Param("page")Page<Map<String, Object>> page,
                                          @Param("sort") SortVo sortMap,
                                          @Param("dto") JgChangeRegistrationReformDto dto ,
                                          @Param("roleIds") List<String> roleIds,
                                          @Param("currentUserId")String currentUserId);

    List<ChangeRegistrationReformVo> queryChangeRegistrationReformInIds(@Param("ids") List<String> ids);

    Map<String, Object> getDetail(@Param("id")String id);

    Map<String, Object> getInspectDetail(@Param("id")String id);

    Map<String, Object> getUseDetail(@Param("id")String id);

    Page<Map<String, Object>> getEquipListPage(@Param("page")Page<Map<String, Object>> page,@Param("factoryNum") String factoryNum,@Param("equList")String equList,@Param("equCategory")String equCategory);

    void updatePromoter(@Param("id")Long id);

    @Select("select name from tz_equipment_category  where code=#{code}")
    String getEquiplistNameByEquiplist(String code);

    /**
     *
     * @param id 主键
     * @param equListCode 设备种类
     * @return 压力管道或者其他详情
     */
    List<Map<String, Object>> getDetailById(@Param("id") Long id, @Param("equListCode") String equListCode);

    List<CompanyEquipCountDto> queryForFlowingEquipList();

    IPage<IdxBizJgProjectContraption> queryJgProjectContraptionPage(Page<IdxBizJgProjectContraption> page,@Param("companyCode") String useUnitCreditCode,@Param("proIds") Set<String> proIds);

    /**
     * 查询指定装置下的管道，样式为汇总表样式
     * @param projectContraptionSeq 装置id
     * @return List<Map<String, Object>>
     */
    List<Map<String, Object>> selectPieLineListByProjectId(@Param("projectContraptionSeq") String projectContraptionSeq);
}
