package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgReformNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgReformNotice;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.ReformVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 改造告知 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-19
 */
public interface JgReformNoticeMapper extends CustomBaseMapper<JgReformNotice> {
    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 改造告知列表
     */
    Page<Map<String,Object>> queryForPage(Page<JgReformNotice> page,
                                      @Param("sort") SortVo sortMap,
                                      @Param ("param") JgReformNoticeDto model,
                                      @Param("type") String type, @Param("orgCode") String orgCode,
                                      @Param("currentUserId") String currentUserId);


    Map<String, Object> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);

    void updatePromoter(@Param("id") Long id);

    List<CompanyEquipCountDto> queryForFlowingEquipList();

    List<ReformVo> queryReformInIds(@Param("ids") List<String> ids);
}
