package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.maintainNotice;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintainNotice;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.core.RouterEventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 维修告知编辑处理器
 */
@Component
public class MaintainNoticeDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final MaintainNoticeEditUpdateService maintainNoticeEditUpdateService;

    protected MaintainNoticeDataChangeHandler(RouterEventPublisher routerEventPublisher, ApplicationContext applicationContext, MaintainNoticeEditUpdateService maintainNoticeEditUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.maintainNoticeEditUpdateService = maintainNoticeEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_MAINTENANCE_NOTIFICATION.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Boolean.TRUE;
    }

    /**
     * 管道专用
     *
     * @param applyNo 单据号
     *                判断数据是实时落库，还是先存到json
     * @return 是否需要临时存储
     */
    @Override
    public Boolean requiresTemporarySave(String applyNo) {
        return false;
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        return maintainNoticeEditUpdateService.getEqsByApplyNo(applyNo);
    }


    @Override
    public Boolean bizIsFinished(String applyNo) {
        JgMaintainNotice jgMaintainNotice = maintainNoticeEditUpdateService.getMaintainNoticeService().getOne(new LambdaQueryWrapper<JgMaintainNotice>().eq(JgMaintainNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgMaintainNotice::getNoticeStatus));
        return jgMaintainNotice.getNoticeStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
    }

    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        JgMaintainNotice jgMaintainNotice = maintainNoticeEditUpdateService.getMaintainNoticeService().getOne(new LambdaQueryWrapper<JgMaintainNotice>().eq(JgMaintainNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgMaintainNotice::getProjectContraptionId));
        return Stream.of(jgMaintainNotice.getProjectContraptionId())
                .filter(id -> id != null && !id.trim().isEmpty())
                .collect(Collectors.toSet());
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
