package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.newProject;

import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.core.RouterEventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 新增装置编辑处理器
 */
@Component
public class NewProjectDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final NewProjectEditUpdateService newProjectEditUpdateService;

    protected NewProjectDataChangeHandler(NewProjectEditUpdateService newProjectEditUpdateService, RouterEventPublisher routerEventPublisher, ApplicationContext applicationContext) {
        super(routerEventPublisher, applicationContext);
        this.newProjectEditUpdateService = newProjectEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_NEW_PROJECT.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        List<FieldChangeMeta> bizEditColumns = new ArrayList<>();
        // 更新管道纳管状态、使用登记证编号业务信息
        newProjectEditUpdateService.updateBizInfo(bizId);
        return bizEditColumns;
    }

    @Override
    public Boolean beforeCheck(String projectContraptionId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return true;
    }

    /**
     * 管道专用
     * @param applyNo 单据号
     * 判断数据是实时落库，还是先存到json
     * @return 是否需要临时存储
     */
    @Override
    public Boolean requiresTemporarySave(String applyNo) {
        return false;
    }

    @Override
    public Set<String> getEqs(String projectContraptionId) {
        return newProjectEditUpdateService.getEqsByProjectContraptionId(projectContraptionId);
    }

    @Override
    public Boolean bizIsFinished(String projectContraptionId) {
        return Boolean.TRUE;
    }

    @Override
    public Set<String> getProjectContraptionIds(String projectContraptionId) {
        return Collections.singleton(projectContraptionId);
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
