package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.scrapCancel;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgScrapCancel;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.core.RouterEventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 设备注销报废编辑处理器
 */
@Component
public class ScrapCancelDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final ScrapCancelEditUpdateService scrapCancelEditUpdateService;

    protected ScrapCancelDataChangeHandler(RouterEventPublisher routerEventPublisher, ApplicationContext applicationContext, ScrapCancelEditUpdateService scrapCancelEditUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.scrapCancelEditUpdateService = scrapCancelEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_EQUIPMENT_MOVE_CANCEL.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Boolean.TRUE;
    }

    /**
     * 管道专用
     * @param applyNo 单据号
     * 判断数据是实时落库，还是先存到json
     * @return 是否需要临时存储
     */
    @Override
    public Boolean requiresTemporarySave(String applyNo) {
        return false;
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        return scrapCancelEditUpdateService.getEqsByApplyNo(applyNo);
    }

    @Override
    public Boolean bizIsFinished(String applyNo) {
        JgScrapCancel jgScrapCancel = scrapCancelEditUpdateService.getMainService().getOne(new LambdaQueryWrapper<JgScrapCancel>().eq(JgScrapCancel::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgScrapCancel::getAuditStatus));
        return jgScrapCancel.getAuditStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName());
    }

    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        return Collections.emptySet();
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
