package com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.biz.factory.GradeStrategyFactory;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.EquipCreateOrEditEvent;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.service.IQualityScoreUpdate;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImplService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Date;
import java.util.Set;

@Component
@RequiredArgsConstructor
public class ProjectQualityScoreUpdateService implements IQualityScoreUpdate {


    private final GradeStrategyFactory gradeStrategyFactory;

    private final IdxBizJgProjectContraptionServiceImplService idxBizJgProjectContraptionService;

    @Value("${grade.calculation.strategy:MAX_GRADE}")
    private String activeStrategy;

    @Override
    public Boolean support(EquipCreateOrEditEvent.EquipType equipType) {
        return EquipCreateOrEditEvent.EquipType.project.equals(equipType);
    }

    @Async
    @Override
    public void update(String bizType, Set<String> projectContraptionIds) {
        projectContraptionIds.parallelStream().forEach(projectContraptionId -> {
            Integer level = this.getReminderLevel(bizType, projectContraptionId);
            LambdaUpdateWrapper<IdxBizJgProjectContraption> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(IdxBizJgProjectContraption::getSequenceNbr, projectContraptionId);
            updateWrapper.set(IdxBizJgProjectContraption::getDataQualityScore, level);
            updateWrapper.set(BaseEntity::getRecDate, new Date());
            idxBizJgProjectContraptionService.update(updateWrapper);
        });
    }


    public Integer getReminderLevel(String bizType, String projectContraptionId) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionService.getById(projectContraptionId);
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        matchItemDto.setBizType(bizType);
        matchItemDto.setEquList(projectContraption.getEquList());
        matchItemDto.setEquCategory(projectContraption.getEquCategory());
        matchItemDto.setEquDefine(projectContraption.getEquDefine());
        matchItemDto.setRegType(CommonReminderService.getRegTypeByDataSource(projectContraption.getDataSource()));
        matchItemDto.setIsRegister(projectContraption.getIsIntoManagement() && StringUtils.isNotEmpty(projectContraption.getUseRegistrationCode()));
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(projectContraptionId);
        reminderItemDto.setEquipNo(projectContraption.getProjectContraptionNo());
        reminderItemDto.setEquipName(projectContraption.getProjectContraption());
        reminderItemDto.setDetailData(BeanUtil.beanToMap(matchItemDto));
        return gradeStrategyFactory.getStrategy(activeStrategy).calculateGrade(Collections.singletonList(reminderItemDto), matchItemDto);

    }
}
