package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.jg.biz.core.BaseService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgConstructionInfoService;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgConstructionInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgConstructionInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgConstructionInfoMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.List;

/**
 * 施工信息表服务实现类
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Service
public class IdxBizJgConstructionInfoServiceImpl extends BaseService<IdxBizJgConstructionInfoMapper, IdxBizJgConstructionInfo> implements IIdxBizJgConstructionInfoService {

    public boolean saveOrUpdateData(IdxBizJgConstructionInfo constructionInfo){
        return super.saveOrUpdateWithNull(constructionInfo);
    }

    @Override
    public boolean saveOrUpdateBatch(List<IdxBizJgConstructionInfo> constructionInfoList) {
        return super.saveOrUpdateBatch(constructionInfoList);
    }

    //查询最新的记录
    public IdxBizJgConstructionInfo queryNewestDetailByRecord(String record) {
        IdxBizJgConstructionInfo result = new IdxBizJgConstructionInfo();
        QueryWrapper<IdxBizJgConstructionInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(IdxBizJgConstructionInfo::getRecord,record).orderByDesc(IdxBizJgConstructionInfo::getUscDate);
        List<IdxBizJgConstructionInfo> constructionInfoList = list(queryWrapper);
        if(!ValidationUtil.isEmpty(constructionInfoList)){
            BeanUtils.copyProperties(constructionInfoList.get(0),result);;
        }
        return result;
    }

    /**
     * 查询最新的一条施工信息主键
     * @param record 设备唯一标识
     * @return 主键
     */
    public IdxBizJgConstructionInfo queryNewestDetailIdByRecord(String record) {
        IdxBizJgConstructionInfo result = new IdxBizJgConstructionInfo();
        QueryWrapper<IdxBizJgConstructionInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(IdxBizJgConstructionInfo::getRecord,record).orderByDesc(IdxBizJgConstructionInfo::getUscDate).select(TzsBaseEntity::getSequenceNbr);
        List<IdxBizJgConstructionInfo> constructionInfoList = list(queryWrapper);
        if(!ValidationUtil.isEmpty(constructionInfoList)){
            BeanUtils.copyProperties(constructionInfoList.get(0),result);;
        }
        return result;
    }
}