package com.yeejoin.amos.boot.module.jg.biz.statistics.service;

import cn.hutool.core.bean.BeanUtil;
import com.yeejoin.amos.boot.module.common.api.dto.TechParamItem;
import com.yeejoin.amos.boot.module.common.api.entity.ESEquipmentInfo;
import com.yeejoin.amos.boot.module.common.biz.utils.TechParamUtil;
import com.yeejoin.amos.boot.module.jg.biz.edit.backup.TechParamsBackupService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
@RequiredArgsConstructor
public class StatisticsDataUpdateService {

    private final TechParamsBackupService techParamsBackupService;


    public List<ESEquipmentInfo.TechParam> getTechParams(String equList, String record) {
        Object params = techParamsBackupService.getTechParams(equList, record);
        Map<String, Object> paramsMap = BeanUtil.beanToMap(params);
        List<TechParamItem> techParamItems = TechParamUtil.getParamMetaList(equList);
        List<ESEquipmentInfo.TechParam> techParams = new ArrayList<>();
        techParamItems.forEach(techParamItem -> {
            ESEquipmentInfo.TechParam techParam = new ESEquipmentInfo.TechParam(techParamItem, paramsMap.get(techParamItem.getParamKey()));
            techParams.add(techParam);
        });
        return techParams;
    }

}
