package com.yeejoin.amos.boot.module.jyjc.api.enums;

import com.yeejoin.amos.boot.module.common.api.enums.AlertCallEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author LiuLin
 */

@AllArgsConstructor
@Getter
public enum JYJCTypeEnum {

    /**
     * 检验检测类型
     */
    AZJDJY("AZJDJY", "安装监督检验", "jy", BizTypeEnum.SUPERVISE.getCode()),
    GZJDJY("GZJDJY", "改造监督检验", "jy", BizTypeEnum.SUPERVISE.getCode()),
    WXJDJY("WXJDJY", "维修监督检验", "jy", BizTypeEnum.SUPERVISE.getCode()),
    SCJY("SCJY", "首次检验", "jy", BizTypeEnum.FIRST_INSPECTION.getCode()),
    DQJY("DQJY", "定期检验", "jy", BizTypeEnum.FIRST_INSPECTION.getCode()),
    WTJY("WTJY", "委托检验", "jy", BizTypeEnum.ENTRUST.getCode()),
    DTJC("DTJC", "电梯检测", "jc", BizTypeEnum.DETECTION.getCode());

    private final String code;
    private final String name;

    private final String openBizType;

    private final String bizType;

    public static JYJCTypeEnum of(String code) {
        for (JYJCTypeEnum e : JYJCTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static List<JYJCTypeEnum> getListByBizType(String bizType) {
        if (StringUtils.isEmpty(bizType)) {
            return Arrays.asList(JYJCTypeEnum.values());
        }
        return Arrays.stream(JYJCTypeEnum.values()).filter(e -> e.getBizType().equals(bizType)).collect(Collectors.toList());
    }

    public static List<HashMap<String,Object>> getTypeEnumList() {
        List<HashMap<String, Object>> list = new ArrayList<>();
        for (JYJCTypeEnum testEnum : EnumSet.allOf(JYJCTypeEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("title", testEnum.getName());
            map.put("value", testEnum.getCode());
            list.add(map);
        }
        return list;
    }
}
