package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum CompanyAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    ADDRESS("详细地址", "address", TechnicalParameter.ParamType.STRING,""),
    EXPIRYDATE("许可有效期", "expiryDate",TechnicalParameter.ParamType.DATE,""),
    UNIT_TYPE("企业类型", "unitType",null,""),
    REGULATORY_LABELS("企业等级", "regulatoryLabels",null,""),
    INDUSTRY_SUPERVISOR("行业主管部门", "industrySupervisor",null,""),
    ITEM_CODE("许可项目", "itemCode",null,""),
    SUB_ITEM_CODE("许可子项目", "subItemCode",null,""),
    OPERATING_STATUS("经营状态", "operatingStatus",null,""),
    EQUIP_CATEGORY("监管设备类型", "equipCategory",null,""),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (CompanyAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if(TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)){
                jsonObject.put("type","inputNumber");
            }else if(TechnicalParameter.ParamType.STRING.equals(item.paramType)){
                jsonObject.put("type","input");
            }else if(TechnicalParameter.ParamType.DATE.equals(item.paramType)){
                jsonObject.put("type","date");
            }else {
                jsonObject.put("type","select");
            }
            jsonObject.put("conditions",ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
