package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum ConditionEnum {

    /**
     * 类型枚举
     */

    stringEq("等于", "eq", TechnicalParameter.ParamType.STRING),
    like("匹配", "like", TechnicalParameter.ParamType.STRING),
    notLike("不匹配", "notLike", TechnicalParameter.ParamType.STRING),
    numberEq("等于", "eq", TechnicalParameter.ParamType.BIG_DECIMAL),
    numberGt("大于", "gt", TechnicalParameter.ParamType.BIG_DECIMAL),
    numberLt("小于", "lt", TechnicalParameter.ParamType.BIG_DECIMAL),
    numberGe("大于等于", "ge", TechnicalParameter.ParamType.BIG_DECIMAL),
    numberLe("小于等于", "le", TechnicalParameter.ParamType.BIG_DECIMAL),
    dateEq("等于", "eq", TechnicalParameter.ParamType.DATE),
    dateGt("大于", "gt", TechnicalParameter.ParamType.DATE),
    dateLt("小于", "lt", TechnicalParameter.ParamType.DATE),
    dateGe("大于等于", "ge", TechnicalParameter.ParamType.DATE),
    dateLe("小于等于", "le", TechnicalParameter.ParamType.DATE),
    in("包含","in", null),
    notin("不包含","notin", null),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;

    public static JSONArray getByCode(TechnicalParameter.ParamType paramType) {
        JSONArray jsonArray = new JSONArray();
        for (ConditionEnum value : values()) {
            if (value.paramType == paramType) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("label", value.name);
                jsonObject.put("value", value.code);
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }
}
