package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum EquipAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    USE_ORG_CODE("使用登记证编号", "USE_ORG_CODE", TechnicalParameter.ParamType.STRING,""),
    EQU_LIST("设备种类", "EQU_LIST",null,""),
    EQU_CATEGORY("设备类别", "EQU_CATEGORY",null,""),
    EQU_DEFINE("设备品种", "EQU_DEFINE",null,""),
    PRODUCT_NAME("设备名称", "PRODUCT_NAME", TechnicalParameter.ParamType.STRING,""),
    TECH_PARAM("技术参数", "techParam", null,""),
    PARAM_RANGE("参数范围", "paramRange", TechnicalParameter.ParamType.STRING,""),
    NEXT_INSPECT_DATE("检验有效期", "nextInspectDate", TechnicalParameter.ParamType.DATE,""),
    EQU_STATE("检验有效期", "EQU_STATE", null,""),
//    SUPERVISORY_CODE("赋码状态", "", null,""),
//    SUPERVISORY_CODE("设备等级", "", null,""),
//    SUPERVISORY_CODE("使用年限", "", null,""),
    UNIT_TYPE("所属单位类型", "unitType", null,""),
    USC_UNIT_NAME("所属单位名称", "USC_UNIT_NAME", TechnicalParameter.ParamType.STRING,""),
    PRODUCE_UNIT_NAME("制造单位名称", "PRODUCE_UNIT_NAME", TechnicalParameter.ParamType.STRING,""),
    DESIGN_UNIT_NAME("设计单位名称", "DESIGN_UNIT_NAME", TechnicalParameter.ParamType.STRING,""),
    ME_UNIT_NAME("维保单位名称", "ME_UNIT_NAME", TechnicalParameter.ParamType.STRING,""),
    AZUSC_UNIT_NAME("安装单位名称", "USC_UNIT_NAME", TechnicalParameter.ParamType.STRING,""),
    CODE96333("96333识别码", "CODE96333", TechnicalParameter.ParamType.STRING,""),
    SUPERVISORY_CODE("监管码", "SUPERVISORY_CODE", TechnicalParameter.ParamType.STRING,""),
    EQU_TYPE("设备型号", "EQU_TYPE", TechnicalParameter.ParamType.STRING,""),
    PRODUCE_DATE("制造日期", "PRODUCE_DATE", TechnicalParameter.ParamType.DATE,""),
//    PRODUCE_DATE("是否进口", "PRODUCE_DATE", TechnicalParameter.ParamType.DATE,""),
    USE_PLACE_CODE("使用地点", "USE_PLACE_CODE", TechnicalParameter.ParamType.STRING,""),
    USE_PLACE("使用场所", "USE_PLACE", null,""),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (EquipAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if(TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)){
                jsonObject.put("type","inputNumber");
            }else if(TechnicalParameter.ParamType.STRING.equals(item.paramType)){
                jsonObject.put("type","input");
            }else if(TechnicalParameter.ParamType.DATE.equals(item.paramType)){
                jsonObject.put("type","date");
            }else {
                jsonObject.put("type","select");
            }
            jsonObject.put("conditions",ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
