package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum PersonAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    NAME("人员名称", "name", TechnicalParameter.ParamType.STRING,""),
    NEWPOST("人员类型", "newPost",TechnicalParameter.ParamType.DATE,""),
    SUBPOST("人员子类型", "subPost",null,""),
//    REGULATORY_LABELS("有无资质", "regulatoryLabels",null,""),
//    REGULATORY_LABELS("资质状态", "regulatoryLabels",null,""),
    CERT_TYPE("证书类型", "certType",null,""),
    PERMISSION_LEVEL("证书级别", "permissionLevel",null,""),
    JOB_ITEM("作业项目", "jobItem",null,""),
    ISSUE_DATE("发证日期", "issueDate",TechnicalParameter.ParamType.DATE,""),
    EDUCATION("学历", "education",null,""),
    ADDRESS("住址", "address",TechnicalParameter.ParamType.STRING,""),
    EQUIP_TYPE("监管设备类型", "equipType",null,""),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (PersonAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if(TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)){
                jsonObject.put("type","inputNumber");
            }else if(TechnicalParameter.ParamType.STRING.equals(item.paramType)){
                jsonObject.put("type","input");
            }else if(TechnicalParameter.ParamType.DATE.equals(item.paramType)){
                jsonObject.put("type","date");
            }else {
                jsonObject.put("type","select");
            }
            jsonObject.put("conditions",ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
