package com.yeejoin.amos.boot.module.statistics.api.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.jg.api.annotation.DictCode2DictName;
import lombok.Data;
import java.util.Date;
import java.util.List;

/**
 * 设备
 */
@Data
public class EquipInfoVo {

    @ExcelProperty("管辖机构名称")
    private String ORG_BRANCH_NAME;

    @ExcelProperty("使用单位名称")
    private String USE_UNIT_NAME;

    @ExcelProperty("使用单位统一信用代码")
    private String USE_UNIT_CREDIT_CODE;

    @ExcelProperty("设备种类名称")
    private String EQU_LIST;

    @ExcelProperty("设备类别名称")
    private String EQU_CATEGORY;

    @ExcelProperty("设备品种名称")
    private String EQU_DEFINE;

    @ExcelProperty("使用登记证编号")
    private String USE_ORG_CODE;

    @ExcelProperty("96333电梯码")
    private String CODE96333;

    @ExcelProperty("设备代码")
    private String EQU_CODE;

    @ExcelProperty("监管码")
    private String SUPERVISORY_CODE;

    @ExcelProperty("使用场所")
    private String USE_PLACE;

    @ExcelProperty("详细地址")
    private String ADDRESS;

    @ExcelProperty("设备状态")
    private Integer EQU_STATE;

    @ExcelProperty("认领状态")
    private String STATUS;

    @ExcelProperty("安全管理员")
    private String SAFETY_MANAGER;

    @ExcelProperty("安全管理员电话")
    private String PHONE;

    @ExcelProperty("维保单位统一信用代码")
    private String MAINTAIN_UNIT;

    @ExcelProperty("维保单位名称")
    private String MAINTAIN_UNIT_NAME;

    @ExcelProperty("单位内部编号")
    private String USE_INNER_CODE;

    @ExcelProperty("出场编号")
    private String FACTORY_NUM;

    @ExcelProperty("制造单位名称")
    private String PRODUCE_UNIT_NAME;

    @ExcelProperty("安改维单位统一信用代码")
    private String USC_UNIT_CREDIT_CODE;

    @ExcelProperty("安改维单位统名称")
    private String USC_UNIT_NAME;

    @ExcelProperty("投用日期")
    private Date USC_DATE;

    @ExcelProperty("产品名称")
    private String PRODUCT_NAME;

    @ExcelProperty("设备品牌")
    private String BRAND_NAME;

    @ExcelProperty("设备型号")
    private String EQU_TYPE;

    @ExcelProperty("制造日期")
    private String PRODUCE_DATE;

    @ExcelProperty("设备来源")
    private String DATA_SOURCE;

    @ExcelProperty("是否车用气瓶")
    private String WHETHER_VEHICLE_CYLINDER;

    @ExcelProperty("是否撬装式压力容器")
    private String WHETHER_SKID_MOUNTED_PRESSURE_VESSEL;

    @ExcelProperty("气瓶分类")
    private String CYLINDER_CATEGORY;

    @ExcelProperty("是否纳管")
    private Boolean IS_INTO_MANAGEMENT;

    @ExcelProperty("工程装置")
    private String PROJECT_CONTRAPTION;

    @ExcelProperty("信息化")
    private String INFORMATION_SITUATION;

    @ExcelProperty("工程装置id")
    private String projectContraptionId;

    @ExcelProperty("数据质量等级")
    private Integer dataQualityScore;

    @ExcelProperty("设计单位统一信用代码")
    private String designUnitCreditCode;

    @ExcelProperty("设计单位名称")
    private String designUnitName;

    @ExcelProperty("制造单位统一社会信用代码")
    private String produceUnitCreditCode;

    /**
     * 最新一条检验信息
     */
    @ExcelProperty("")
    private List<Inspection> inspections;

    /**
     * 最新一条维保信息
     */
    @ExcelProperty("")
    private List<Maintenance> maintenances;

    /**
     * 技术参数
     */
    @ExcelProperty("")
    private List<TechParam> techParams;

    @Data
    public static class TechParam {

        @ExcelProperty("")
        private String paramKey;

        @ExcelProperty("")
        private String paramLabel;

        @ExcelProperty("")
        private String strValue;

        @ExcelProperty("")
        private Long longValue;

        @ExcelProperty("")
        private Double doubleValue;

        @ExcelProperty("")
        private Boolean boolValue;

        @ExcelProperty("")
        private Date dateValue;
    }


    @Data
    public static class Inspection {
        @ExcelProperty("")
        private String sequenceNbr;

        /**
         * 检验类型
         */
        @ExcelProperty("")
        private String inspectType;

        /**
         * 检验机构名称
         */
        @ExcelProperty("")
        private String inspectOrgName;

        /**
         * 检验人员
         */
        @ExcelProperty("")
        private String inspectStaff;


        /**
         * 检验结论
         */
        @ExcelProperty("")
        private String inspectConclusion;

        /**
         * 检验日期
         */
        @ExcelProperty("")
        private Date inspectDate;

        /**
         * 下次检验日期
         */
        @ExcelProperty("")
        private Date nextInspectDate;

        /**
         * 检验机构编码
         */
        @ExcelProperty("")
        private String inspectOrgCode;

        /**
         * 报告编号
         */
        @ExcelProperty("")
        private String inspectReportNo;
    }

    @Data
    public static class Maintenance {

        @ExcelProperty("")
        private String sequenceNbr;

        /**
         * 维保单位统一社会信用代码
         */

        @ExcelProperty("")
        private String meUnitCreditCode;
        /**
         * 维保单位名称
         */

        @ExcelProperty("")
        private String meUnitName;
        /**
         * 维保备案合同
         */
        @ExcelProperty("")
        private String repairInform;
        /**
         * 维保合同开始日期
         */
        @ExcelProperty("")
        private Date informStart;
        /**
         * 维保合同结束日期
         */
        @ExcelProperty("")
        private Date informEnd;
        /**
         * 维保负责人姓名
         */
        @ExcelProperty("")
        private String meMaster;
        /**
         * 维保负责人身份证
         */

        @ExcelProperty("")
        private String meMasterId;
        /**
         * 紧急救援电话
         */

        @ExcelProperty("")
        private String emergencyCall;

        /**
         * 维保周期
         */
        @ExcelProperty("")
        private String meCycle;
        /**
         * 大修周期
         */

        @ExcelProperty("")
        private String overhaulCycle;
        /**
         * 24小时维保电话
         */
        @ExcelProperty("")
        private String me24Telephone;
    }
}
